/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.models;

import com.apptimize.ABTDataStore;
import com.apptimize.ABTLogger;
import com.apptimize.Apptimize;
import com.apptimize.filter.ABTFilterEnvParams;
import com.apptimize.filter.ABTFilterEnvironment;
import com.apptimize.filter.ABTFilterResult;
import com.apptimize.filter.ABTFilterableObject;
import com.apptimize.filter.ABTNamedFilter;
import com.apptimize.models.ABTAlteration;
import com.apptimize.models.ABTHotfixVariant;
import com.apptimize.models.ABTSdkParameters;
import com.apptimize.models.ABTSeedGroup;
import com.apptimize.models.ABTVariant;
import com.apptimize.models.results.ABTResultEntryMetadataProcessed;
import com.apptimize.support.properties.ABTConfigProperties;
import com.apptimize.util.ABTLRUCache;
import haxe.Exception;
import haxe.NativeStackTrace;
import haxe.Serializer;
import haxe.Unserializer;
import haxe.ds.IntMap;
import haxe.ds.StringMap;
import haxe.format.JsonParser;
import haxe.format.JsonPrinter;
import haxe.lang.Closure;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.Function;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Lambda;
import haxe.root.Std;
import haxe.root.Type;

public class ABTMetadata
extends HxObject {
    public volatile Object _jsonData;
    public volatile Array<ABTSeedGroup> _seedGroups;
    public volatile Array<ABTHotfixVariant> _hotfixes;
    public volatile ABTLRUCache<Array<ABTAlteration>> _alterationCache;
    public volatile Array<ABTNamedFilter> _namedFilters;
    public volatile StringMap<ABTFilterResult> _namedFiltersEvaluations;
    public volatile String _etag;
    public StringMap<Array<String>> _secondaryValues;

    public ABTMetadata(EmptyObject emptyObject) {
    }

    public ABTMetadata() {
        ABTMetadata.__hx_ctor_apptimize_models_ABTMetadata(this);
    }

    protected static void __hx_ctor_apptimize_models_ABTMetadata(ABTMetadata aBTMetadata) {
        aBTMetadata._alterationCache = new ABTLRUCache(Runtime.toInt(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.ALTERATION_CACHE_SIZE_KEY)));
        aBTMetadata._namedFiltersEvaluations = new StringMap();
    }

    public static ABTMetadata loadFromString(String string) {
        ABTMetadata aBTMetadata = new ABTMetadata();
        aBTMetadata._load_data(string);
        return aBTMetadata;
    }

    public void copyPersistentValues(ABTMetadata aBTMetadata) {
        if (aBTMetadata == null) {
            return;
        }
        if (aBTMetadata._namedFiltersEvaluations != null) {
            this._namedFiltersEvaluations = aBTMetadata._namedFiltersEvaluations.copy();
        }
    }

    public ABTFilterEnvironment makeEnvironment(ABTFilterEnvParams aBTFilterEnvParams, ABTSdkParameters aBTSdkParameters) {
        StringMap<Array<String>> stringMap = this._secondaryValues;
        StringMap<String> stringMap2 = new StringMap<String>();
        stringMap2.set("groupsApiUrl", this.getGroupsUrlTemplate("lpilot_targeting_id"));
        stringMap2.set("cohortsApiUrl", this.getGroupsUrlTemplate("m_cohort_id"));
        StringMap<String> stringMap3 = stringMap2;
        if (aBTSdkParameters != null && aBTSdkParameters.callServerUrls != null) {
            stringMap3 = aBTSdkParameters.callServerUrls;
        }
        return new ABTFilterEnvironment(aBTFilterEnvParams, stringMap3, stringMap, this.getSequenceNumber(), this._namedFilters, this._namedFiltersEvaluations);
    }

    public String getGroupsUrlTemplate(String string) {
        String string2 = Runtime.toString(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.GROUPS_BASE_URL_KEY));
        String string3 = string2 + "/api/pilot-groups/?appKey={lapp_key}&pilotTargetingId={" + string + "}";
        return string3;
    }

    public void _load_data(String string) {
        this._alterationCache = new ABTLRUCache(Runtime.toInt(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.ALTERATION_CACHE_SIZE_KEY)));
        this._jsonData = new JsonParser(Runtime.toString(string)).doParse();
        this.reprocessJson();
    }

    public void reprocessJson() {
        Object t;
        int n;
        Array array;
        if (this._jsonData == null) {
            throw (RuntimeException)Exception.thrown("Unable to process metadata");
        }
        this._seedGroups = new Array();
        if ((Array)Runtime.getField(this._jsonData, "seedGroups", true) != null) {
            array = (Array)Runtime.getField(this._jsonData, "seedGroups", true);
            for (n = 0; n < array.length; ++n) {
                t = array.__get(n);
                this._seedGroups.push(new ABTSeedGroup(t));
            }
        }
        this._hotfixes = new Array();
        if ((Array)Runtime.getField(this._jsonData, "hotfixes", true) != null) {
            array = (Array)Runtime.getField(this._jsonData, "hotfixes", true);
            for (n = 0; n < array.length; ++n) {
                t = array.__get(n);
                this._hotfixes.push(new ABTHotfixVariant(t));
            }
        }
        ABTLogger.i("JSONNamedFilters: " + Std.string((Array)Runtime.getField(this._jsonData, "namedFilters", true)), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.models.ABTMetadata", "src/apptimize/models/ABTMetadata.hx", "reprocessJson"}, new String[]{"lineNumber"}, new double[]{199.0}));
        this._namedFilters = new Array();
        if ((Array)Runtime.getField(this._jsonData, "namedFilters", true) != null) {
            array = (Array)Runtime.getField(this._jsonData, "namedFilters", true);
            for (n = 0; n < array.length; ++n) {
                t = array.__get(n);
                this._namedFilters.push(new ABTNamedFilter(t));
            }
        }
    }

    public Array<ABTAlteration> uncachedSelectAlterationsIntoArray(ABTFilterEnvironment aBTFilterEnvironment, Object object) {
        ABTFilterableObject aBTFilterableObject;
        int n;
        boolean bl = Runtime.eq(object, null) ? true : Runtime.toBool((Boolean)object);
        Array<ABTAlteration> array = new Array<ABTAlteration>();
        Array<ABTFilterableObject> array2 = this._seedGroups;
        for (n = 0; n < array2.length; ++n) {
            aBTFilterableObject = array2.__get(n);
            ((ABTSeedGroup)aBTFilterableObject).selectAlterationsIntoArray(aBTFilterEnvironment, array, false);
        }
        array2 = this._hotfixes;
        for (n = 0; n < array2.length; ++n) {
            aBTFilterableObject = (ABTHotfixVariant)array2.__get(n);
            ((ABTVariant)aBTFilterableObject).selectAlterationsIntoArray(aBTFilterEnvironment, array, false);
        }
        return array;
    }

    public Array<ABTAlteration> selectAlterationsIntoArray(ABTFilterEnvironment aBTFilterEnvironment) {
        Array<ABTAlteration> array = this.uncachedSelectAlterationsIntoArray(aBTFilterEnvironment, false);
        this.metadataProcessed(aBTFilterEnvironment, array);
        return array;
    }

    public Array<String> extractNeededSecondaryUrls(ABTFilterEnvironment aBTFilterEnvironment) {
        ABTFilterableObject aBTFilterableObject;
        Array<Object> array = new Array<String>();
        int n = 0;
        HxObject hxObject = this._seedGroups;
        while (n < ((Array)hxObject).length) {
            aBTFilterableObject = ((Array)hxObject).__get(n);
            ++n;
            array = array.concat(aBTFilterableObject.getUrlKeys());
        }
        n = 0;
        hxObject = this._hotfixes;
        while (n < ((Array)hxObject).length) {
            aBTFilterableObject = (ABTHotfixVariant)((Array)hxObject).__get(n);
            ++n;
            array = array.concat(aBTFilterableObject.getUrlKeys());
        }
        Array<String> array2 = new Array<String>();
        hxObject = new StringMap();
        for (int i = 0; i < array.length; ++i) {
            String string = (String)array.__get(i);
            if (((StringMap)hxObject).exists(string)) continue;
            String string2 = aBTFilterEnvironment.secondaryUrlForKey(string);
            ((StringMap)hxObject).set(string, string2);
            if (string2 == null) continue;
            array2.push(string2);
        }
        return array2;
    }

    public ABTSdkParameters extractSdkParameters(ABTFilterEnvironment aBTFilterEnvironment) {
        ABTSdkParameters aBTSdkParameters = new ABTSdkParameters((Object)null);
        if (this._seedGroups != null) {
            Array<ABTSeedGroup> array = this._seedGroups;
            for (int i = 0; i < array.length; ++i) {
                ABTSeedGroup aBTSeedGroup = array.__get(i);
                aBTSeedGroup.applySdkParameters(aBTSdkParameters, aBTFilterEnvironment);
            }
        }
        return aBTSdkParameters;
    }

    public void metadataProcessed(ABTFilterEnvironment aBTFilterEnvironment, Array<ABTAlteration> array) {
        ABTResultEntryMetadataProcessed aBTResultEntryMetadataProcessed = new ABTResultEntryMetadataProcessed(aBTFilterEnvironment, this.getSequenceNumber(), this.getVariantsCyclesPhases(array));
        ABTDataStore.sharedInstance().addResultLogEntry(aBTFilterEnvironment, aBTResultEntryMetadataProcessed);
    }

    public Array<Object> getVariantsCyclesPhases(Array<ABTAlteration> array) {
        IntMap<DynamicObject> intMap = new IntMap<DynamicObject>();
        for (int i = 0; i < array.length; ++i) {
            ABTAlteration aBTAlteration = array.__get(i);
            ABTVariant aBTVariant = aBTAlteration.getVariant();
            int n = aBTVariant.getPhase();
            String string = "v" + aBTVariant.getVariantID() + "_" + aBTVariant.getCycle();
            if (Type.getClass(aBTVariant) == ABTHotfixVariant.class || intMap.exists(aBTVariant.getVariantID())) continue;
            int n2 = aBTVariant.getVariantID();
            DynamicObject dynamicObject = null;
            int n3 = aBTVariant.getVariantID();
            int n4 = aBTVariant.getCycle();
            dynamicObject = new DynamicObject(new String[0], new Object[0], new String[]{"c", "p", "v"}, new double[]{n4, n, n3});
            intMap.set(n2, dynamicObject);
        }
        return Lambda.array(intMap);
    }

    public Object getMetaData() {
        return this._jsonData;
    }

    public int getSequenceNumber() {
        return (int)Runtime.getField_f(this._jsonData, "sequenceNumber", true);
    }

    public Array<String> getCheckinUrls() {
        return (Array)Runtime.getField(this._jsonData, "checkinUrls", true);
    }

    public String getAppKey() {
        return Runtime.toString(Runtime.getField(this._jsonData, "appKey", true));
    }

    public String getEtag() {
        return this._etag;
    }

    public void setEtag(String string) {
        this._etag = string;
    }

    public void setSecondaryValues(StringMap<Array<String>> stringMap) {
        this._secondaryValues = stringMap;
    }

    public StringMap<Array<String>> getSecondaryValues() {
        return this._secondaryValues;
    }

    public Array<String> getDisabledVersions() {
        boolean bl = Runtime.toBool((Boolean)Runtime.getField(this._jsonData, "disableAllVersions", false));
        Array array = (Array)Runtime.getField(this._jsonData, "disabledCrossPlatformVersions", false);
        Array<String> array2 = new Array<String>();
        if (bl) {
            array2.push(Apptimize.getApptimizeSDKVersion());
        }
        if (array != null) {
            array2 = array2.concat((Array)Runtime.getField(this._jsonData, "disabledCrossPlatformVersions", true));
        }
        return array2;
    }

    public void hxSerialize(Serializer serializer) {
        this.serializeV1(serializer);
        serializer.serialize(this._secondaryValues);
    }

    public void serializeV1(Serializer serializer) {
        Function function = null;
        String string = null;
        serializer.serialize(JsonPrinter.print(this._jsonData, function, string));
        serializer.serialize(this._etag);
    }

    public void hxUnserialize(Unserializer unserializer) {
        this._load_data(Runtime.toString(unserializer.unserialize()));
        this._etag = Runtime.toString(unserializer.unserialize());
        try {
            this._secondaryValues = (StringMap)unserializer.unserialize();
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            this._secondaryValues = null;
        }
        this._namedFiltersEvaluations = new StringMap();
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -1884893679: {
                    if (!string.equals("_jsonData")) break;
                    bl2 = false;
                    this._jsonData = d;
                    return d;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 841640311: {
                    if (!string.equals("_secondaryValues")) break;
                    bl2 = false;
                    this._secondaryValues = (StringMap)object;
                    return object;
                }
                case -1884893679: {
                    if (!string.equals("_jsonData")) break;
                    bl2 = false;
                    this._jsonData = object;
                    return object;
                }
                case 90857972: {
                    if (!string.equals("_etag")) break;
                    bl2 = false;
                    this._etag = Runtime.toString(object);
                    return object;
                }
                case -1572564668: {
                    if (!string.equals("_seedGroups")) break;
                    bl2 = false;
                    this._seedGroups = (Array)object;
                    return object;
                }
                case -1996307050: {
                    if (!string.equals("_namedFiltersEvaluations")) break;
                    bl2 = false;
                    this._namedFiltersEvaluations = (StringMap)object;
                    return object;
                }
                case -193712971: {
                    if (!string.equals("_hotfixes")) break;
                    bl2 = false;
                    this._hotfixes = (Array)object;
                    return object;
                }
                case -2111837087: {
                    if (!string.equals("_namedFilters")) break;
                    bl2 = false;
                    this._namedFilters = (Array)object;
                    return object;
                }
                case 2126153700: {
                    if (!string.equals("_alterationCache")) break;
                    bl2 = false;
                    this._alterationCache = (ABTLRUCache)object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxUnserialize");
                }
                case -1884893679: {
                    if (!string.equals("_jsonData")) break;
                    bl4 = false;
                    return this._jsonData;
                }
                case -1357694597: {
                    if (!string.equals("serializeV1")) break;
                    bl4 = false;
                    return new Closure(this, "serializeV1");
                }
                case -1572564668: {
                    if (!string.equals("_seedGroups")) break;
                    bl4 = false;
                    return this._seedGroups;
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxSerialize");
                }
                case -193712971: {
                    if (!string.equals("_hotfixes")) break;
                    bl4 = false;
                    return this._hotfixes;
                }
                case 299059373: {
                    if (!string.equals("getDisabledVersions")) break;
                    bl4 = false;
                    return new Closure(this, "getDisabledVersions");
                }
                case 2126153700: {
                    if (!string.equals("_alterationCache")) break;
                    bl4 = false;
                    return this._alterationCache;
                }
                case 1634395520: {
                    if (!string.equals("getSecondaryValues")) break;
                    bl4 = false;
                    return new Closure(this, "getSecondaryValues");
                }
                case -2111837087: {
                    if (!string.equals("_namedFilters")) break;
                    bl4 = false;
                    return this._namedFilters;
                }
                case -1740538124: {
                    if (!string.equals("setSecondaryValues")) break;
                    bl4 = false;
                    return new Closure(this, "setSecondaryValues");
                }
                case -1996307050: {
                    if (!string.equals("_namedFiltersEvaluations")) break;
                    bl4 = false;
                    return this._namedFiltersEvaluations;
                }
                case 1984551063: {
                    if (!string.equals("setEtag")) break;
                    bl4 = false;
                    return new Closure(this, "setEtag");
                }
                case 90857972: {
                    if (!string.equals("_etag")) break;
                    bl4 = false;
                    return this._etag;
                }
                case -75558517: {
                    if (!string.equals("getEtag")) break;
                    bl4 = false;
                    return new Closure(this, "getEtag");
                }
                case 841640311: {
                    if (!string.equals("_secondaryValues")) break;
                    bl4 = false;
                    return this._secondaryValues;
                }
                case 284921716: {
                    if (!string.equals("getAppKey")) break;
                    bl4 = false;
                    return new Closure(this, "getAppKey");
                }
                case -107482066: {
                    if (!string.equals("copyPersistentValues")) break;
                    bl4 = false;
                    return new Closure(this, "copyPersistentValues");
                }
                case 751801723: {
                    if (!string.equals("getCheckinUrls")) break;
                    bl4 = false;
                    return new Closure(this, "getCheckinUrls");
                }
                case -275090619: {
                    if (!string.equals("makeEnvironment")) break;
                    bl4 = false;
                    return new Closure(this, "makeEnvironment");
                }
                case -1646037152: {
                    if (!string.equals("getSequenceNumber")) break;
                    bl4 = false;
                    return new Closure(this, "getSequenceNumber");
                }
                case -1279672353: {
                    if (!string.equals("getGroupsUrlTemplate")) break;
                    bl4 = false;
                    return new Closure(this, "getGroupsUrlTemplate");
                }
                case 1626942661: {
                    if (!string.equals("getMetaData")) break;
                    bl4 = false;
                    return new Closure(this, "getMetaData");
                }
                case -99811868: {
                    if (!string.equals("_load_data")) break;
                    bl4 = false;
                    return new Closure(this, "_load_data");
                }
                case 1191777577: {
                    if (!string.equals("getVariantsCyclesPhases")) break;
                    bl4 = false;
                    return new Closure(this, "getVariantsCyclesPhases");
                }
                case 1266471908: {
                    if (!string.equals("reprocessJson")) break;
                    bl4 = false;
                    return new Closure(this, "reprocessJson");
                }
                case -159771425: {
                    if (!string.equals("metadataProcessed")) break;
                    bl4 = false;
                    return new Closure(this, "metadataProcessed");
                }
                case -239633668: {
                    if (!string.equals("uncachedSelectAlterationsIntoArray")) break;
                    bl4 = false;
                    return new Closure(this, "uncachedSelectAlterationsIntoArray");
                }
                case 2092254915: {
                    if (!string.equals("extractSdkParameters")) break;
                    bl4 = false;
                    return new Closure(this, "extractSdkParameters");
                }
                case 577780129: {
                    if (!string.equals("selectAlterationsIntoArray")) break;
                    bl4 = false;
                    return new Closure(this, "selectAlterationsIntoArray");
                }
                case -1966228350: {
                    if (!string.equals("extractNeededSecondaryUrls")) break;
                    bl4 = false;
                    return new Closure(this, "extractNeededSecondaryUrls");
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -1884893679: {
                    if (!string.equals("_jsonData")) break;
                    bl3 = false;
                    return Runtime.toDouble(this._jsonData);
                }
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl = false;
                    this.hxUnserialize((Unserializer)objectArray[0]);
                    break;
                }
                case -107482066: {
                    if (!string.equals("copyPersistentValues")) break;
                    bl = false;
                    this.copyPersistentValues((ABTMetadata)objectArray[0]);
                    break;
                }
                case -1357694597: {
                    if (!string.equals("serializeV1")) break;
                    bl = false;
                    this.serializeV1((Serializer)objectArray[0]);
                    break;
                }
                case -275090619: {
                    if (!string.equals("makeEnvironment")) break;
                    bl = false;
                    return this.makeEnvironment((ABTFilterEnvParams)objectArray[0], (ABTSdkParameters)objectArray[1]);
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl = false;
                    this.hxSerialize((Serializer)objectArray[0]);
                    break;
                }
                case -1279672353: {
                    if (!string.equals("getGroupsUrlTemplate")) break;
                    bl = false;
                    return this.getGroupsUrlTemplate(Runtime.toString(objectArray[0]));
                }
                case 299059373: {
                    if (!string.equals("getDisabledVersions")) break;
                    bl = false;
                    return this.getDisabledVersions();
                }
                case -99811868: {
                    if (!string.equals("_load_data")) break;
                    bl = false;
                    this._load_data(Runtime.toString(objectArray[0]));
                    break;
                }
                case 1634395520: {
                    if (!string.equals("getSecondaryValues")) break;
                    bl = false;
                    return this.getSecondaryValues();
                }
                case 1266471908: {
                    if (!string.equals("reprocessJson")) break;
                    bl = false;
                    this.reprocessJson();
                    break;
                }
                case -1740538124: {
                    if (!string.equals("setSecondaryValues")) break;
                    bl = false;
                    this.setSecondaryValues((StringMap)objectArray[0]);
                    break;
                }
                case -239633668: {
                    if (!string.equals("uncachedSelectAlterationsIntoArray")) break;
                    bl = false;
                    return this.uncachedSelectAlterationsIntoArray((ABTFilterEnvironment)objectArray[0], objectArray.length > 1 ? objectArray[1] : null);
                }
                case 1984551063: {
                    if (!string.equals("setEtag")) break;
                    bl = false;
                    this.setEtag(Runtime.toString(objectArray[0]));
                    break;
                }
                case 577780129: {
                    if (!string.equals("selectAlterationsIntoArray")) break;
                    bl = false;
                    return this.selectAlterationsIntoArray((ABTFilterEnvironment)objectArray[0]);
                }
                case -75558517: {
                    if (!string.equals("getEtag")) break;
                    bl = false;
                    return this.getEtag();
                }
                case -1966228350: {
                    if (!string.equals("extractNeededSecondaryUrls")) break;
                    bl = false;
                    return this.extractNeededSecondaryUrls((ABTFilterEnvironment)objectArray[0]);
                }
                case 284921716: {
                    if (!string.equals("getAppKey")) break;
                    bl = false;
                    return this.getAppKey();
                }
                case 2092254915: {
                    if (!string.equals("extractSdkParameters")) break;
                    bl = false;
                    return this.extractSdkParameters((ABTFilterEnvironment)objectArray[0]);
                }
                case 751801723: {
                    if (!string.equals("getCheckinUrls")) break;
                    bl = false;
                    return this.getCheckinUrls();
                }
                case -159771425: {
                    if (!string.equals("metadataProcessed")) break;
                    bl = false;
                    this.metadataProcessed((ABTFilterEnvironment)objectArray[0], (Array)objectArray[1]);
                    break;
                }
                case -1646037152: {
                    if (!string.equals("getSequenceNumber")) break;
                    bl = false;
                    return this.getSequenceNumber();
                }
                case 1191777577: {
                    if (!string.equals("getVariantsCyclesPhases")) break;
                    bl = false;
                    return this.getVariantsCyclesPhases((Array)objectArray[0]);
                }
                case 1626942661: {
                    if (!string.equals("getMetaData")) break;
                    bl = false;
                    return this.getMetaData();
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("_secondaryValues");
        array.push("_etag");
        array.push("_namedFiltersEvaluations");
        array.push("_namedFilters");
        array.push("_alterationCache");
        array.push("_hotfixes");
        array.push("_seedGroups");
        array.push("_jsonData");
        super.__hx_getFields(array);
    }
}

