/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.models.results;

import com.apptimize.filter.ABTFilterEnvironment;
import com.apptimize.models.ABTJSONObject;
import com.apptimize.support.persistence.ABTPersistence;
import com.apptimize.support.properties.ABTInternalProperties;
import com.apptimize.util.ABTDataLock;
import com.apptimize.util.ABTInt64Utils;
import com.apptimize.util.ABTUtilDictionary;
import com.apptimize.util.PlatformLock;
import haxe.Exception;
import haxe.NativeStackTrace;
import haxe.Serializer;
import haxe.Unserializer;
import haxe._Int64.Int64_Impl_;
import haxe.ds.StringMap;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Date;
import haxe.root.Std;

public class ABTResultEntry
extends ABTJSONObject {
    public static PlatformLock RESULT_ENTRY_CREATION_LOCK = ABTDataLock.getNewLock("result_entry_creation_lock_key");
    public long _id;
    public long _monotonicTimestamp;
    public long _deviceTimestamp;
    public StringMap _userAttributes;
    public StringMap _prefixedAttributes;

    public ABTResultEntry(EmptyObject emptyObject) {
        super(EmptyObject.EMPTY);
    }

    public ABTResultEntry(ABTFilterEnvironment aBTFilterEnvironment) {
        ABTResultEntry.__hx_ctor_apptimize_models_results_ABTResultEntry(this, aBTFilterEnvironment);
    }

    protected static void __hx_ctor_apptimize_models_results_ABTResultEntry(ABTResultEntry aBTResultEntry, ABTFilterEnvironment aBTFilterEnvironment) {
        RESULT_ENTRY_CREATION_LOCK.acquire();
        try {
            aBTResultEntry._id = aBTResultEntry._getNextSequenceNumber();
            aBTResultEntry._deviceTimestamp = Int64_Impl_.fromFloat(Date.now().date.getTimeInMillis());
            aBTResultEntry._monotonicTimestamp = aBTResultEntry._getMonotonicTimestamp(aBTResultEntry._deviceTimestamp);
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            RESULT_ENTRY_CREATION_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        RESULT_ENTRY_CREATION_LOCK.release();
        aBTResultEntry._prefixedAttributes = new StringMap();
        if (aBTFilterEnvironment != null && aBTFilterEnvironment.customProperties.availableProperties != null) {
            aBTFilterEnvironment.customProperties.addJSONProperties(aBTResultEntry._prefixedAttributes);
        }
        ABTInternalProperties.sharedInstance().addJSONProperties(aBTResultEntry._prefixedAttributes);
        aBTFilterEnvironment.applicationProperties.addJSONProperties(aBTResultEntry._prefixedAttributes);
    }

    public long _getNextSequenceNumber() {
        String string = ABTPersistence.loadString(ABTPersistence.kResultEntrySequenceKey, null);
        long l = 0L;
        if (string != null) {
            l = Int64_Impl_.parseString(string);
        }
        ABTPersistence.saveString(ABTPersistence.kResultEntrySequenceKey, "" + Std.string(++l), null, null);
        return l;
    }

    public long _getMonotonicTimestamp(long l) {
        long l2 = l;
        long l3 = 0L;
        String string = ABTPersistence.loadString(ABTPersistence.kResultEntryTimestampKey, null);
        if (string != null) {
            l3 = Int64_Impl_.parseString(string);
        }
        if (l3 >= l) {
            l2 = l3 + 1L;
        }
        ABTPersistence.saveString(ABTPersistence.kResultEntryTimestampKey, "" + Std.string(l2), null, null);
        return l2;
    }

    public StringMap JSONRepresentation() {
        StringMap<Object> stringMap = new StringMap<Object>();
        stringMap.set("ei", ABTInt64Utils.toPreprocessedString(this._id));
        stringMap.set("mt", ABTInt64Utils.toPreprocessedString(this._monotonicTimestamp));
        stringMap.set("dt", ABTInt64Utils.toPreprocessedString(this._deviceTimestamp));
        stringMap.set("pa", ABTUtilDictionary.filterNullValues(this._prefixedAttributes));
        StringMap<Object> stringMap2 = stringMap;
        if (this._userAttributes != null) {
            StringMap<Object> stringMap3 = ABTUtilDictionary.filterNullValues(this._userAttributes);
            stringMap2.set("ua", stringMap3);
        }
        return stringMap2;
    }

    public void hxSerialize(Serializer serializer) {
        ABTInt64Utils._serializeInt64(this._id, serializer);
        ABTInt64Utils._serializeInt64(this._monotonicTimestamp, serializer);
        ABTInt64Utils._serializeInt64(this._deviceTimestamp, serializer);
        serializer.serialize(this._userAttributes);
        serializer.serialize(this._prefixedAttributes);
    }

    public void hxUnserialize(Unserializer unserializer) {
        this._id = ABTInt64Utils._deserializeInt64(unserializer);
        this._monotonicTimestamp = ABTInt64Utils._deserializeInt64(unserializer);
        this._deviceTimestamp = ABTInt64Utils._deserializeInt64(unserializer);
        this._userAttributes = (StringMap)unserializer.unserialize();
        this._prefixedAttributes = (StringMap)unserializer.unserialize();
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 1014580615: {
                    if (!string.equals("_prefixedAttributes")) break;
                    bl2 = false;
                    this._prefixedAttributes = (StringMap)object;
                    return object;
                }
                case 94650: {
                    if (!string.equals("_id")) break;
                    bl2 = false;
                    this._id = Runtime.toLong(object);
                    return object;
                }
                case -1651319391: {
                    if (!string.equals("_userAttributes")) break;
                    bl2 = false;
                    this._userAttributes = (StringMap)object;
                    return object;
                }
                case -144519637: {
                    if (!string.equals("_monotonicTimestamp")) break;
                    bl2 = false;
                    this._monotonicTimestamp = Runtime.toLong(object);
                    return object;
                }
                case 1941913889: {
                    if (!string.equals("_deviceTimestamp")) break;
                    bl2 = false;
                    this._deviceTimestamp = Runtime.toLong(object);
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxUnserialize");
                }
                case 94650: {
                    if (!string.equals("_id")) break;
                    bl4 = false;
                    return this._id;
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxSerialize");
                }
                case -144519637: {
                    if (!string.equals("_monotonicTimestamp")) break;
                    bl4 = false;
                    return this._monotonicTimestamp;
                }
                case -1838984235: {
                    if (!string.equals("JSONRepresentation")) break;
                    bl4 = false;
                    return new Closure(this, "JSONRepresentation");
                }
                case 1941913889: {
                    if (!string.equals("_deviceTimestamp")) break;
                    bl4 = false;
                    return this._deviceTimestamp;
                }
                case -1541068157: {
                    if (!string.equals("_getMonotonicTimestamp")) break;
                    bl4 = false;
                    return new Closure(this, "_getMonotonicTimestamp");
                }
                case -1651319391: {
                    if (!string.equals("_userAttributes")) break;
                    bl4 = false;
                    return this._userAttributes;
                }
                case 806289204: {
                    if (!string.equals("_getNextSequenceNumber")) break;
                    bl4 = false;
                    return new Closure(this, "_getNextSequenceNumber");
                }
                case 1014580615: {
                    if (!string.equals("_prefixedAttributes")) break;
                    bl4 = false;
                    return this._prefixedAttributes;
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl = false;
                    this.hxUnserialize((Unserializer)objectArray[0]);
                    break;
                }
                case 806289204: {
                    if (!string.equals("_getNextSequenceNumber")) break;
                    bl = false;
                    return this._getNextSequenceNumber();
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl = false;
                    this.hxSerialize((Serializer)objectArray[0]);
                    break;
                }
                case -1541068157: {
                    if (!string.equals("_getMonotonicTimestamp")) break;
                    bl = false;
                    return this._getMonotonicTimestamp(Runtime.toLong(objectArray[0]));
                }
                case -1838984235: {
                    if (!string.equals("JSONRepresentation")) break;
                    bl = false;
                    return this.JSONRepresentation();
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("_prefixedAttributes");
        array.push("_userAttributes");
        array.push("_deviceTimestamp");
        array.push("_monotonicTimestamp");
        array.push("_id");
        super.__hx_getFields(array);
    }
}

