/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.models;

import com.apptimize.ABTLogger;
import com.apptimize.filter.ABTFilterEnvironment;
import com.apptimize.filter.ABTFilterResult;
import com.apptimize.filter.ABTFilterableObject;
import com.apptimize.models.ABTAlteration;
import com.apptimize.models.ABTRangeGroup;
import com.apptimize.models.ABTSdkParameters;
import com.apptimize.models.ABTSeed;
import com.apptimize.support.properties.ABTConfigProperties;
import com.apptimize.util.ABTHash;
import haxe.Exception;
import haxe.io.Bytes;
import haxe.io.BytesBuffer;
import haxe.io.Error;
import haxe.lang.Closure;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.Runtime;
import haxe.root.Array;

public class ABTSeedGroup
extends ABTFilterableObject {
    public Array<ABTRangeGroup> rangeGroups;
    public Array<ABTSeed> seeds;

    public ABTSeedGroup(EmptyObject emptyObject) {
        super(EmptyObject.EMPTY);
    }

    public ABTSeedGroup(Object object) {
        super(EmptyObject.EMPTY);
        ABTSeedGroup.__hx_ctor_apptimize_models_ABTSeedGroup(this, object);
    }

    protected static void __hx_ctor_apptimize_models_ABTSeedGroup(ABTSeedGroup aBTSeedGroup, Object object) {
        ABTFilterableObject.__hx_ctor_apptimize_filter_ABTFilterableObject(aBTSeedGroup);
        aBTSeedGroup.fromJSON(object);
    }

    @Override
    public void fromJSON(Object object) {
        Object t;
        int n;
        Array array;
        super.fromJSON(object);
        Object object2 = object;
        this.rangeGroups = new Array();
        if ((Array)Runtime.getField(object2, "rangeGroups", true) != null) {
            array = (Array)Runtime.getField(object2, "rangeGroups", true);
            for (n = 0; n < array.length; ++n) {
                t = array.__get(n);
                this.rangeGroups.push(new ABTRangeGroup(t));
            }
        }
        this.seeds = new Array();
        if ((Array)Runtime.getField(object2, "seeds", true) != null) {
            array = (Array)Runtime.getField(object2, "seeds", true);
            for (n = 0; n < array.length; ++n) {
                t = array.__get(n);
                this.seeds.push(new ABTSeed(t));
            }
        }
    }

    public Bytes computedSeedMaterial(ABTFilterEnvironment aBTFilterEnvironment, boolean bl) {
        try {
            BytesBuffer bytesBuffer = new BytesBuffer();
            Array<ABTSeed> array = this.seeds;
            for (int i = 0; i < array.length; ++i) {
                ABTSeed aBTSeed = array.__get(i);
                Bytes bytes = aBTSeed.computedSeedMaterial(aBTFilterEnvironment, bl);
                int n = bytes.length;
                if (n < 0 || n > bytes.length) {
                    throw (RuntimeException)Exception.thrown(Error.OutsideBounds);
                }
                bytesBuffer.b.write(bytes.b, 0, n);
            }
            return ABTHash.Sha1(bytesBuffer.getBytes());
        }
        catch (Throwable throwable) {
            throw (RuntimeException)Exception.thrown(throwable);
        }
    }

    public int seed(ABTFilterEnvironment aBTFilterEnvironment) {
        boolean bl = this.shouldForceLegacyEncoding(aBTFilterEnvironment);
        Bytes bytes = this.computedSeedMaterial(aBTFilterEnvironment, bl);
        int n = bytes.length;
        if (n < 4) {
            ABTLogger.e("User ID length too short for seed: " + n + ".", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.models.ABTSeedGroup", "src/apptimize/models/ABTSeedGroup.hx", "seed"}, new String[]{"lineNumber"}, new double[]{65.0}));
            return 0;
        }
        int n2 = n - 4;
        int n3 = bytes.b[n2 + 3] & 0xFF | (bytes.b[n2 + 2] & 0xFF) << 8 | (bytes.b[n2 + 1] & 0xFF) << 16 | (bytes.b[n2] & 0xFF) << 24;
        n3 &= 0x3FFFFFFF;
        if (bl) {
            ABTLogger.v("Using Legacy seed for user: " + aBTFilterEnvironment.getAnonID() + ":" + aBTFilterEnvironment.getUserID() + ": " + n3 + ".", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.models.ABTSeedGroup", "src/apptimize/models/ABTSeedGroup.hx", "seed"}, new String[]{"lineNumber"}, new double[]{78.0}));
        } else {
            ABTLogger.v("Got seed for user: " + aBTFilterEnvironment.getAnonID() + ":" + aBTFilterEnvironment.getUserID() + ": " + n3 + ".", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.models.ABTSeedGroup", "src/apptimize/models/ABTSeedGroup.hx", "seed"}, new String[]{"lineNumber"}, new double[]{80.0}));
        }
        return n3;
    }

    public void selectAlterationsIntoArray(ABTFilterEnvironment aBTFilterEnvironment, Array<ABTAlteration> array, boolean bl) {
        Object object = this.performFilterMatchingWithEnvironment(aBTFilterEnvironment);
        if ((ABTFilterResult)((Object)Runtime.getField(object, "result", true)) != ABTFilterResult.ABTFilterResultTrue) {
            return;
        }
        boolean bl2 = this.computeNewOverrideState(bl, object);
        int n = this.seed(aBTFilterEnvironment);
        ABTLogger.v("Calculated seed for user " + aBTFilterEnvironment.getAnonID() + ":" + aBTFilterEnvironment.getUserID() + ": " + n + ".", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.models.ABTSeedGroup", "src/apptimize/models/ABTSeedGroup.hx", "selectAlterationsIntoArray"}, new String[]{"lineNumber"}, new double[]{97.0}));
        Array<ABTRangeGroup> array2 = this.rangeGroups;
        for (int i = 0; i < array2.length; ++i) {
            ABTRangeGroup aBTRangeGroup = array2.__get(i);
            if (aBTRangeGroup.isSelectedBySeed(n)) {
                aBTRangeGroup.selectAlterationsIntoArray(aBTFilterEnvironment, array, bl2);
                continue;
            }
            aBTRangeGroup.selectAlterationsIntoArray(aBTFilterEnvironment, array, true);
        }
    }

    @Override
    public Array<Object> getUrlKeyProviders() {
        return this.asUrlProviders(this.rangeGroups);
    }

    public void applySdkParameters(ABTSdkParameters aBTSdkParameters, ABTFilterEnvironment aBTFilterEnvironment) {
        Object object = this.performFilterMatchingWithEnvironment(aBTFilterEnvironment);
        if ((ABTFilterResult)((Object)Runtime.getField(object, "result", true)) == ABTFilterResult.ABTFilterResultTrue) {
            int n = this.seed(aBTFilterEnvironment);
            Array<ABTRangeGroup> array = this.rangeGroups;
            for (int i = 0; i < array.length; ++i) {
                ABTRangeGroup aBTRangeGroup = array.__get(i);
                if (!aBTRangeGroup.isSelectedBySeed(n)) continue;
                aBTRangeGroup.applySdkParameters(aBTSdkParameters, aBTFilterEnvironment);
            }
        }
    }

    public boolean shouldForceLegacyEncoding(ABTFilterEnvironment aBTFilterEnvironment) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        Array<ABTSeed> array = this.seeds;
        for (n = 0; n < array.length; ++n) {
            ABTSeed aBTSeed = array.__get(n);
            if (!Runtime.valEq("constant", aBTSeed.type) || !Runtime.valEq("experiment", aBTSeed.value) && !Runtime.valEq("feature flag", aBTSeed.value) && !Runtime.valEq("feature config", aBTSeed.value)) continue;
            bl2 = true;
        }
        n = Runtime.toInt(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.APPTIMIZE_MAXEXP_SEED_KEY));
        if (bl2 && n2 < n) {
            bl = true;
        }
        return bl;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 109314082: {
                    if (!string.equals("seeds")) break;
                    bl2 = false;
                    this.seeds = (Array)object;
                    return object;
                }
                case -1121690255: {
                    if (!string.equals("rangeGroups")) break;
                    bl2 = false;
                    this.rangeGroups = (Array)object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -395476140: {
                    if (!string.equals("shouldForceLegacyEncoding")) break;
                    bl4 = false;
                    return new Closure(this, "shouldForceLegacyEncoding");
                }
                case -1121690255: {
                    if (!string.equals("rangeGroups")) break;
                    bl4 = false;
                    return this.rangeGroups;
                }
                case 1131284726: {
                    if (!string.equals("applySdkParameters")) break;
                    bl4 = false;
                    return new Closure(this, "applySdkParameters");
                }
                case 109314082: {
                    if (!string.equals("seeds")) break;
                    bl4 = false;
                    return this.seeds;
                }
                case -159436324: {
                    if (!string.equals("getUrlKeyProviders")) break;
                    bl4 = false;
                    return new Closure(this, "getUrlKeyProviders");
                }
                case -1244981358: {
                    if (!string.equals("fromJSON")) break;
                    bl4 = false;
                    return new Closure(this, "fromJSON");
                }
                case 577780129: {
                    if (!string.equals("selectAlterationsIntoArray")) break;
                    bl4 = false;
                    return new Closure(this, "selectAlterationsIntoArray");
                }
                case 1910521445: {
                    if (!string.equals("computedSeedMaterial")) break;
                    bl4 = false;
                    return new Closure(this, "computedSeedMaterial");
                }
                case 3526257: {
                    if (!string.equals("seed")) break;
                    bl4 = false;
                    return new Closure(this, "seed");
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        int n = string.hashCode();
        boolean bl = true;
        if (string != null) {
            switch (n) {
                case -1244981358: 
                case -159436324: {
                    if ((n != -159436324 || !string.equals("getUrlKeyProviders")) && !string.equals("fromJSON")) break;
                    bl = false;
                    return Runtime.slowCallField(this, string, objectArray);
                }
                case 1910521445: {
                    if (!string.equals("computedSeedMaterial")) break;
                    bl = false;
                    return this.computedSeedMaterial((ABTFilterEnvironment)objectArray[0], Runtime.toBool((Boolean)objectArray[1]));
                }
                case -395476140: {
                    if (!string.equals("shouldForceLegacyEncoding")) break;
                    bl = false;
                    return this.shouldForceLegacyEncoding((ABTFilterEnvironment)objectArray[0]);
                }
                case 3526257: {
                    if (!string.equals("seed")) break;
                    bl = false;
                    return this.seed((ABTFilterEnvironment)objectArray[0]);
                }
                case 1131284726: {
                    if (!string.equals("applySdkParameters")) break;
                    bl = false;
                    this.applySdkParameters((ABTSdkParameters)objectArray[0], (ABTFilterEnvironment)objectArray[1]);
                    break;
                }
                case 577780129: {
                    if (!string.equals("selectAlterationsIntoArray")) break;
                    bl = false;
                    this.selectAlterationsIntoArray((ABTFilterEnvironment)objectArray[0], (Array)objectArray[1], Runtime.toBool((Boolean)objectArray[2]));
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("seeds");
        array.push("rangeGroups");
        super.__hx_getFields(array);
    }
}

