/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.api;

import com.apptimize.ABTDataStore;
import com.apptimize.ABTLogger;
import com.apptimize.ApptimizeInternal;
import com.apptimize.api.ABTApiClient;
import com.apptimize.api.ABTApiResultsPost__post_167__Fun;
import com.apptimize.api.ABTApiResultsPost__post_175__Fun;
import com.apptimize.api.ABTApiResultsPost_onFailure_33__Fun;
import com.apptimize.api.ABTApiResultsPost_postNextRequestForID_33__Fun;
import com.apptimize.api.ABTApiResultsPost_pushRequest_33__Fun;
import com.apptimize.http.ABTHttpRequest;
import com.apptimize.http.ABTHttpResponse;
import com.apptimize.models.ABTMetadata;
import com.apptimize.models.results.ABTResultLog;
import com.apptimize.support.persistence.ABTPersistence;
import com.apptimize.support.properties.ABTConfigProperties;
import com.apptimize.util.ABTDataLock;
import com.apptimize.util.ABTDispatch;
import com.apptimize.util.PlatformLock;
import haxe.Exception;
import haxe.NativeStackTrace;
import haxe.Serializer;
import haxe.Unserializer;
import haxe.ds.StringMap;
import haxe.io.Bytes;
import haxe.lang.Closure;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.Function;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Std;
import hx.concurrent.atomic._AtomicInt.AtomicIntImpl;
import hx.concurrent.collection._SynchronizedLinkedList.SynchronizedLinkedListImpl;
import hx.concurrent.collection._SynchronizedLinkedList.SynchronizedLinkedList_Impl_;

public class ABTApiResultsPost
extends HxObject {
    public static int MAX_FAILURE_DELAY_MS;
    public static int DEFAULT_FAILURE_DELAY_MS;
    public static AtomicIntImpl _failureDelayMs;
    public static StringMap<Object> _pendingMap;
    public static SynchronizedLinkedListImpl<ABTApiResultsPost> _pendingResults;
    public static ABTDispatch _postDispatch;
    public static volatile boolean _loadedPending;
    public static PlatformLock PENDING_LOCK;
    public ABTApiClient _apiClient;
    public String _appKey;
    public String _uniqueID;
    public Bytes _requestBytes;
    public Function _success;
    public Function _failure;
    public int _failureCount;
    public String _url;

    public ABTApiResultsPost(EmptyObject emptyObject) {
    }

    public ABTApiResultsPost(ABTApiClient aBTApiClient, String string, ABTResultLog aBTResultLog, Function function, Function function2) {
        ABTApiResultsPost.__hx_ctor_apptimize_api_ABTApiResultsPost(this, aBTApiClient, string, aBTResultLog, function, function2);
    }

    protected static void __hx_ctor_apptimize_api_ABTApiResultsPost(ABTApiResultsPost aBTApiResultsPost, ABTApiClient aBTApiClient, String string, ABTResultLog aBTResultLog, Function function, Function function2) {
        Bytes bytes;
        aBTApiResultsPost._failureCount = 0;
        aBTApiResultsPost._apiClient = aBTApiClient;
        aBTApiResultsPost._appKey = string;
        aBTApiResultsPost._success = function;
        aBTApiResultsPost._failure = function2;
        aBTApiResultsPost._uniqueID = aBTResultLog.getUniqueUserKey();
        aBTApiResultsPost._url = aBTApiResultsPost._getUrl(string);
        aBTApiResultsPost._requestBytes = bytes = Bytes.ofString(aBTResultLog.toJSON(), null);
    }

    public static int _getPendingResultsCount() {
        int n = 0;
        PENDING_LOCK.acquire();
        try {
            n = _pendingResults.get_length();
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        PENDING_LOCK.release();
        return n;
    }

    public static void onSuccess(ABTApiResultsPost aBTApiResultsPost, ABTHttpResponse aBTHttpResponse) {
        ABTApiResultsPost.clearFailureDelay();
        PENDING_LOCK.acquire();
        try {
            _pendingResults.remove(aBTApiResultsPost);
            int n = ABTApiResultsPost.decrementPendingCount(aBTApiResultsPost._uniqueID);
            if (n > 0) {
                ABTApiResultsPost.postNextRequestForID(aBTApiResultsPost._uniqueID);
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        PENDING_LOCK.release();
        if (aBTApiResultsPost != null && aBTApiResultsPost._success != null) {
            aBTApiResultsPost._success.__hx_invoke1_o(0.0, aBTHttpResponse);
        }
    }

    public static void postNextRequestForID(String string) {
        PENDING_LOCK.acquire();
        try {
            Object object = _pendingResults.iterator();
            while (Runtime.toBool((Boolean)Runtime.callField(object, "hasNext", null))) {
                ABTApiResultsPost aBTApiResultsPost = (ABTApiResultsPost)Runtime.callField(object, "next", null);
                if (!Runtime.valEq(aBTApiResultsPost._uniqueID, string)) continue;
                ABTApiResultsPost_postNextRequestForID_33__Fun aBTApiResultsPost_postNextRequestForID_33__Fun = new ABTApiResultsPost_postNextRequestForID_33__Fun(aBTApiResultsPost);
                if (_postDispatch != null) {
                    _postDispatch.dispatch(aBTApiResultsPost_postNextRequestForID_33__Fun, 0);
                } else {
                    ABTDispatch.dispatchImmediately(aBTApiResultsPost_postNextRequestForID_33__Fun);
                }
                break;
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        PENDING_LOCK.release();
    }

    public static int decrementPendingCount(String string) {
        int n = 0;
        PENDING_LOCK.acquire();
        try {
            n = Runtime.toInt(_pendingMap.get(string));
            if (--n == 0) {
                _pendingMap.remove(string);
            } else {
                _pendingMap.set(string, n);
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        PENDING_LOCK.release();
        return n;
    }

    public static int incrementFailureDelay() {
        int n = ABTApiResultsPost._failureDelayMs._value.get() * 2;
        if (n > MAX_FAILURE_DELAY_MS) {
            n = MAX_FAILURE_DELAY_MS;
        }
        ABTApiResultsPost._failureDelayMs._value.set(n);
        return ABTApiResultsPost._failureDelayMs._value.get();
    }

    public static void clearFailureDelay() {
        int n = DEFAULT_FAILURE_DELAY_MS;
        ABTApiResultsPost._failureDelayMs._value.set(n);
    }

    public static void onFailure(ABTApiResultsPost aBTApiResultsPost, ABTHttpResponse aBTHttpResponse) {
        if (Runtime.compare(aBTApiResultsPost._failureCount, ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.MAXIMUM_RESULT_POST_FAILURE_KEY)) > 0) {
            ABTLogger.e("Dropping result post after repeated failure.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.api.ABTApiResultsPost", "src/apptimize/api/ABTApiResultsPost.hx", "onFailure"}, new String[]{"lineNumber"}, new double[]{267.0}));
            PENDING_LOCK.acquire();
            try {
                _pendingResults.remove(aBTApiResultsPost);
                int n = ABTApiResultsPost.decrementPendingCount(aBTApiResultsPost._uniqueID);
                if (n > 0) {
                    ABTApiResultsPost.postNextRequestForID(aBTApiResultsPost._uniqueID);
                }
            }
            catch (Throwable throwable) {
                NativeStackTrace.exception.set(throwable);
                Object object = Exception.caught(throwable).unwrap();
                PENDING_LOCK.release();
                throw (RuntimeException)Exception.thrown(object);
            }
            PENDING_LOCK.release();
        } else {
            ABTApiResultsPost_onFailure_33__Fun aBTApiResultsPost_onFailure_33__Fun = new ABTApiResultsPost_onFailure_33__Fun(aBTApiResultsPost);
            if (_postDispatch != null) {
                _postDispatch.dispatch(aBTApiResultsPost_onFailure_33__Fun, ABTApiResultsPost.incrementFailureDelay());
            } else {
                ABTDispatch.dispatchImmediately(aBTApiResultsPost_onFailure_33__Fun);
            }
        }
        if (aBTApiResultsPost._failure != null) {
            aBTApiResultsPost._failure.__hx_invoke1_o(0.0, aBTHttpResponse);
        }
    }

    public static void pushRequest(ABTApiResultsPost aBTApiResultsPost, Object object) {
        boolean bl = Runtime.eq(object, null) ? true : Runtime.toBool((Boolean)object);
        PENDING_LOCK.acquire();
        try {
            _pendingResults.add(aBTApiResultsPost);
            if (!_pendingMap.exists(aBTApiResultsPost._uniqueID)) {
                _pendingMap.set(aBTApiResultsPost._uniqueID, 1);
                ABTApiResultsPost_pushRequest_33__Fun aBTApiResultsPost_pushRequest_33__Fun = new ABTApiResultsPost_pushRequest_33__Fun(aBTApiResultsPost);
                if (_postDispatch != null) {
                    _postDispatch.dispatch(aBTApiResultsPost_pushRequest_33__Fun, 0);
                } else {
                    ABTDispatch.dispatchImmediately(aBTApiResultsPost_pushRequest_33__Fun);
                }
            } else {
                _pendingMap.set(aBTApiResultsPost._uniqueID, Runtime.toInt(Runtime.plus(_pendingMap.get(aBTApiResultsPost._uniqueID), 1)));
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object2 = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object2);
        }
        PENDING_LOCK.release();
    }

    public static void savePendingLogs() {
        PENDING_LOCK.acquire();
        try {
            ABTPersistence.saveObject(ABTPersistence.kResultPostsListKey, _pendingResults.toArray(), null, null);
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        PENDING_LOCK.release();
    }

    public static void loadPendingLogs() {
        PENDING_LOCK.acquire();
        try {
            if (!_loadedPending) {
                Array array = (Array)ABTPersistence.loadObject(ABTPersistence.kResultPostsListKey, null);
                try {
                    Array array2 = array == null ? new Array() : array;
                    for (int i = 0; i < array2.length; ++i) {
                        ABTApiResultsPost aBTApiResultsPost = (ABTApiResultsPost)array2.__get(i);
                        ABTApiResultsPost.pushRequest(aBTApiResultsPost, false);
                    }
                }
                catch (Throwable throwable) {
                    NativeStackTrace.exception.set(throwable);
                    Object object = Exception.caught(throwable).unwrap();
                    ABTLogger.e("Unable to load pending results posts: " + Std.string(object), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.api.ABTApiResultsPost", "src/apptimize/api/ABTApiResultsPost.hx", "loadPendingLogs"}, new String[]{"lineNumber"}, new double[]{335.0}));
                }
            }
            _loadedPending = true;
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            PENDING_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        PENDING_LOCK.release();
    }

    public static void startDispatching(int n) {
        _postDispatch.start(n);
    }

    public String _getUrl(String string) {
        ABTMetadata aBTMetadata = ABTDataStore.sharedInstance().getMetaData(string);
        if (aBTMetadata == null) {
            return null;
        }
        Array<String> array = aBTMetadata.getCheckinUrls();
        if (array == null || array.length < 1) {
            return null;
        }
        int n = (int)Math.floor((double)(array.length - 1 + 1) * Math.random());
        String string2 = "server/v4/";
        return array.__get(n) + string2;
    }

    public void _post() {
        if (!ApptimizeInternal._isInitialized()) {
            return;
        }
        if (this._url == null) {
            this._url = this._getUrl(this._appKey);
            if (this._url == null) {
                ABTLogger.e("Unable to post results until metadata is available.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.api.ABTApiResultsPost", "src/apptimize/api/ABTApiResultsPost.hx", "_post"}, new String[]{"lineNumber"}, new double[]{155.0}));
                ABTApiResultsPost.onFailure(this, null);
                return;
            }
        }
        ABTLogger.v("Posting results to: " + this._url, new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.api.ABTApiResultsPost", "src/apptimize/api/ABTApiResultsPost.hx", "_post"}, new String[]{"lineNumber"}, new double[]{161.0}));
        ABTApiResultsPost aBTApiResultsPost = this;
        ABTHttpRequest.post(this._url, this._requestBytes, this._appKey, new ABTApiResultsPost__post_167__Fun(aBTApiResultsPost), new ABTApiResultsPost__post_175__Fun(aBTApiResultsPost));
    }

    public void incrementFailureCountForCode(int n) {
        if (n >= 400) {
            ++this._failureCount;
        }
    }

    public void hxSerialize(Serializer serializer) {
        serializer.serialize(this._appKey);
        serializer.serialize(this._requestBytes);
        serializer.serialize(this._failureCount);
        serializer.serialize(this._url);
        serializer.serialize(this._uniqueID);
    }

    public void hxUnserialize(Unserializer unserializer) {
        this._appKey = Runtime.toString(unserializer.unserialize());
        this._requestBytes = (Bytes)unserializer.unserialize();
        this._failureCount = Runtime.toInt(unserializer.unserialize());
        this._url = Runtime.toString(unserializer.unserialize());
        this._uniqueID = Runtime.toString(unserializer.unserialize());
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 1975189380: {
                    if (!string.equals("_failureCount")) break;
                    bl2 = false;
                    this._failureCount = (int)d;
                    return d;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 2946224: {
                    if (!string.equals("_url")) break;
                    bl2 = false;
                    this._url = Runtime.toString(object);
                    return object;
                }
                case 1922619654: {
                    if (!string.equals("_apiClient")) break;
                    bl2 = false;
                    this._apiClient = (ABTApiClient)object;
                    return object;
                }
                case 1975189380: {
                    if (!string.equals("_failureCount")) break;
                    bl2 = false;
                    this._failureCount = Runtime.toInt(object);
                    return object;
                }
                case 1297377693: {
                    if (!string.equals("_appKey")) break;
                    bl2 = false;
                    this._appKey = Runtime.toString(object);
                    return object;
                }
                case 1271650379: {
                    if (!string.equals("_failure")) break;
                    bl2 = false;
                    this._failure = (Function)object;
                    return object;
                }
                case -203942389: {
                    if (!string.equals("_uniqueID")) break;
                    bl2 = false;
                    this._uniqueID = Runtime.toString(object);
                    return object;
                }
                case 491054788: {
                    if (!string.equals("_success")) break;
                    bl2 = false;
                    this._success = (Function)object;
                    return object;
                }
                case -826832645: {
                    if (!string.equals("_requestBytes")) break;
                    bl2 = false;
                    this._requestBytes = (Bytes)object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxUnserialize");
                }
                case 1922619654: {
                    if (!string.equals("_apiClient")) break;
                    bl4 = false;
                    return this._apiClient;
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxSerialize");
                }
                case 1297377693: {
                    if (!string.equals("_appKey")) break;
                    bl4 = false;
                    return this._appKey;
                }
                case 1642643714: {
                    if (!string.equals("incrementFailureCountForCode")) break;
                    bl4 = false;
                    return new Closure(this, "incrementFailureCountForCode");
                }
                case -203942389: {
                    if (!string.equals("_uniqueID")) break;
                    bl4 = false;
                    return this._uniqueID;
                }
                case 91181439: {
                    if (!string.equals("_post")) break;
                    bl4 = false;
                    return new Closure(this, "_post");
                }
                case -826832645: {
                    if (!string.equals("_requestBytes")) break;
                    bl4 = false;
                    return this._requestBytes;
                }
                case 1459123032: {
                    if (!string.equals("_getUrl")) break;
                    bl4 = false;
                    return new Closure(this, "_getUrl");
                }
                case 491054788: {
                    if (!string.equals("_success")) break;
                    bl4 = false;
                    return this._success;
                }
                case 2946224: {
                    if (!string.equals("_url")) break;
                    bl4 = false;
                    return this._url;
                }
                case 1271650379: {
                    if (!string.equals("_failure")) break;
                    bl4 = false;
                    return this._failure;
                }
                case 1975189380: {
                    if (!string.equals("_failureCount")) break;
                    bl4 = false;
                    return this._failureCount;
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 1975189380: {
                    if (!string.equals("_failureCount")) break;
                    bl3 = false;
                    return this._failureCount;
                }
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl = false;
                    this.hxUnserialize((Unserializer)objectArray[0]);
                    break;
                }
                case 1459123032: {
                    if (!string.equals("_getUrl")) break;
                    bl = false;
                    return this._getUrl(Runtime.toString(objectArray[0]));
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl = false;
                    this.hxSerialize((Serializer)objectArray[0]);
                    break;
                }
                case 91181439: {
                    if (!string.equals("_post")) break;
                    bl = false;
                    this._post();
                    break;
                }
                case 1642643714: {
                    if (!string.equals("incrementFailureCountForCode")) break;
                    bl = false;
                    this.incrementFailureCountForCode(Runtime.toInt(objectArray[0]));
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("_url");
        array.push("_failureCount");
        array.push("_failure");
        array.push("_success");
        array.push("_requestBytes");
        array.push("_uniqueID");
        array.push("_appKey");
        array.push("_apiClient");
        super.__hx_getFields(array);
    }

    static {
        AtomicIntImpl atomicIntImpl;
        MAX_FAILURE_DELAY_MS = 60000;
        DEFAULT_FAILURE_DELAY_MS = 1000;
        AtomicIntImpl atomicIntImpl2 = null;
        _failureDelayMs = atomicIntImpl2 = (atomicIntImpl = new AtomicIntImpl(DEFAULT_FAILURE_DELAY_MS));
        _pendingMap = new StringMap();
        _pendingResults = SynchronizedLinkedList_Impl_._new(null);
        _postDispatch = new ABTDispatch(Runtime.toString("Results Post Dispatch Queue"));
        _loadedPending = false;
        PENDING_LOCK = ABTDataLock.getNewLock("pending_results_key");
    }
}

