/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.filter;

import com.apptimize.ABTLogger;
import com.apptimize.filter.ABTCompoundFilter;
import com.apptimize.filter.ABTFilterEnvironment;
import com.apptimize.filter.ABTFilterOperator;
import com.apptimize.filter.ABTFilterPropertySource;
import com.apptimize.filter.ABTFilterResult;
import com.apptimize.filter.ABTFilterType;
import com.apptimize.filter.ABTListFilter;
import com.apptimize.filter.ABTNamedFilterProxy;
import com.apptimize.filter.ABTSetFilter;
import com.apptimize.filter.ABTSimpleFilter;
import com.apptimize.filter.ABTUnknownFilter;
import haxe.lang.Closure;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Reflect;
import haxe.root.Std;
import haxe.root.Type;

public class ABTFilter
extends HxObject {
    public static String kABTFilterKeyValue = "value";
    public static String kABTFilterKeyType = "type";
    public static String kABTFilterKeyProperty = "property";
    public static String kABTFilterKeyOperator = "operator";
    public static String kABTFilterKeyPropertySource = "propertySource";
    public static String kABTFilterKeyCallServerInputs = "callServerInputs";
    public static String kABTFilterKeyCallURLKey = "callServerUrlKey";
    public static String kABTFilterKeyUserAttribute = "userAttribute";
    public static String kABTFilterKeyPrefixedAttribute = "prefixedAttribute";
    public static String kABTFilterKeyNamedFilter = "namedFilter";
    public String property;
    public ABTFilterPropertySource propertySource;
    public Object value;
    public ABTFilterType filterType;
    public ABTFilterOperator filterOperator;
    public String callServerURLKey;

    public ABTFilter(EmptyObject emptyObject) {
    }

    public ABTFilter() {
        ABTFilter.__hx_ctor_apptimize_filter_ABTFilter(this);
    }

    protected static void __hx_ctor_apptimize_filter_ABTFilter(ABTFilter aBTFilter) {
    }

    public static ABTFilter filterFromJSON(Object object) {
        ABTFilterType aBTFilterType = ABTFilter.filterForTypeFromJSON(object);
        Class clazz = (Class)ABTFilter.classForType(aBTFilterType);
        if (clazz == null) {
            ABTLogger.e("Unable to find filter type: " + Std.string((Object)aBTFilterType), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.filter.ABTFilter", "src/apptimize/filter/ABTFilter.hx", "filterFromJSON"}, new String[]{"lineNumber"}, new double[]{110.0}));
            return null;
        }
        ABTFilter aBTFilter = (ABTFilter)Type.createInstance(clazz, new Array<Object>(new Object[0]));
        aBTFilter.fromJSON(object);
        return aBTFilter;
    }

    public static Object classForType(ABTFilterType aBTFilterType) {
        if (aBTFilterType == ABTFilterType.ABTFilterTypeSimple) {
            return ABTSimpleFilter.class;
        }
        if (aBTFilterType == ABTFilterType.ABTFilterTypeCompound) {
            return ABTCompoundFilter.class;
        }
        if (aBTFilterType == ABTFilterType.ABTFilterTypeList) {
            return ABTListFilter.class;
        }
        if (aBTFilterType == ABTFilterType.ABTFilterTypeSet) {
            return ABTSetFilter.class;
        }
        if (aBTFilterType == ABTFilterType.ABTFilterTypeNamed) {
            return ABTNamedFilterProxy.class;
        }
        return ABTUnknownFilter.class;
    }

    public static ABTFilterType filterForTypeFromJSON(Object object) {
        ABTFilterOperator aBTFilterOperator = ABTFilter.operatorFromString(Runtime.toString(Reflect.field(object, kABTFilterKeyOperator)));
        ABTFilterType aBTFilterType = ABTFilter.typeFromOperator(aBTFilterOperator);
        return aBTFilterType;
    }

    public static ABTFilterOperator operatorFromString(String string) {
        if (Runtime.valEq("=", string)) {
            return ABTFilterOperator.ABTFilterOperatorEquals;
        }
        if (Runtime.valEq("!=", string)) {
            return ABTFilterOperator.ABTFilterOperatorNotEquals;
        }
        if (Runtime.valEq("regex", string)) {
            return ABTFilterOperator.ABTFilterOperatorRegex;
        }
        if (Runtime.valEq("not_regex", string)) {
            return ABTFilterOperator.ABTFilterOperatorNotRegex;
        }
        if (Runtime.valEq(">", string)) {
            return ABTFilterOperator.ABTFilterOperatorGreaterThan;
        }
        if (Runtime.valEq(">=", string)) {
            return ABTFilterOperator.ABTFilterOperatorGreaterThanOrEqual;
        }
        if (Runtime.valEq("<", string)) {
            return ABTFilterOperator.ABTFilterOperatorLessThan;
        }
        if (Runtime.valEq("<=", string)) {
            return ABTFilterOperator.ABTFilterOperatorLessThanOrEqual;
        }
        if (Runtime.valEq("in", string)) {
            return ABTFilterOperator.ABTFilterOperatorInList;
        }
        if (Runtime.valEq("not_in", string)) {
            return ABTFilterOperator.ABTFilterOperatorNotInList;
        }
        if (Runtime.valEq("intersection", string)) {
            return ABTFilterOperator.ABTFilterOperatorIntersection;
        }
        if (Runtime.valEq("or", string)) {
            return ABTFilterOperator.ABTFilterOperatorCompoundOr;
        }
        if (Runtime.valEq("and", string)) {
            return ABTFilterOperator.ABTFilterOperatorCompoundAnd;
        }
        if (Runtime.valEq("not", string)) {
            return ABTFilterOperator.ABTFilterOperatorCompoundSingleNot;
        }
        if (Runtime.valEq("is_null", string)) {
            return ABTFilterOperator.ABTFilterOperatorCompoundSingleIsNull;
        }
        if (Runtime.valEq("is_not_null", string)) {
            return ABTFilterOperator.ABTFilterOperatorCompoundSingleIsNotNull;
        }
        if (Runtime.valEq("is_property_null", string)) {
            return ABTFilterOperator.ABTFilterOperatorPropertyIsNull;
        }
        if (Runtime.valEq("is_property_not_null", string)) {
            return ABTFilterOperator.ABTFilterOperatorPropertyIsNotNull;
        }
        if (Runtime.valEq("is_recognized_property", string)) {
            return ABTFilterOperator.ABTFilterOperatorPropertyIsRecognized;
        }
        if (Runtime.valEq("is_not_recognized_property", string)) {
            return ABTFilterOperator.ABTFilterOperatorPropertyIsNotRecognized;
        }
        if (Runtime.valEq("is_recognized_operator", string)) {
            return ABTFilterOperator.ABTFilterOperatorOperatorIsRecognized;
        }
        if (Runtime.valEq("is_not_recognized_operator", string)) {
            return ABTFilterOperator.ABTFilterOperatorOperatorIsNotRecognized;
        }
        if (Runtime.valEq("value_of", string)) {
            return ABTFilterOperator.ABTFilterOperatorValueOf;
        }
        return ABTFilterOperator.ABTFilterOperatorUnknown;
    }

    public static ABTFilterType typeFromOperator(ABTFilterOperator aBTFilterOperator) {
        switch (aBTFilterOperator) {
            case ABTFilterOperatorUnknown: {
                break;
            }
            case ABTFilterOperatorEquals: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorNotEquals: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorRegex: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorNotRegex: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorGreaterThan: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorGreaterThanOrEqual: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorLessThan: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorLessThanOrEqual: {
                return ABTFilterType.ABTFilterTypeSimple;
            }
            case ABTFilterOperatorInList: {
                return ABTFilterType.ABTFilterTypeList;
            }
            case ABTFilterOperatorNotInList: {
                return ABTFilterType.ABTFilterTypeList;
            }
            case ABTFilterOperatorIntersection: {
                return ABTFilterType.ABTFilterTypeSet;
            }
            case ABTFilterOperatorCompoundOr: {
                return ABTFilterType.ABTFilterTypeCompound;
            }
            case ABTFilterOperatorCompoundAnd: {
                return ABTFilterType.ABTFilterTypeCompound;
            }
            case ABTFilterOperatorCompoundSingleNot: {
                return ABTFilterType.ABTFilterTypeCompound;
            }
            case ABTFilterOperatorCompoundSingleIsNull: {
                return ABTFilterType.ABTFilterTypeCompound;
            }
            case ABTFilterOperatorCompoundSingleIsNotNull: {
                return ABTFilterType.ABTFilterTypeCompound;
            }
            case ABTFilterOperatorPropertyIsNull: {
                return ABTFilterType.ABTFilterTypePropertyless;
            }
            case ABTFilterOperatorPropertyIsNotNull: {
                return ABTFilterType.ABTFilterTypePropertyless;
            }
            case ABTFilterOperatorPropertyIsRecognized: {
                return ABTFilterType.ABTFilterTypePropertyless;
            }
            case ABTFilterOperatorPropertyIsNotRecognized: {
                return ABTFilterType.ABTFilterTypePropertyless;
            }
            case ABTFilterOperatorOperatorIsRecognized: {
                return ABTFilterType.ABTFilterTypePropertyless;
            }
            case ABTFilterOperatorOperatorIsNotRecognized: {
                return ABTFilterType.ABTFilterTypePropertyless;
            }
            case ABTFilterOperatorValueOf: {
                return ABTFilterType.ABTFilterTypeNamed;
            }
        }
        ABTLogger.e("Unknown filter type. Filter match is unknown.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.filter.ABTFilter", "src/apptimize/filter/ABTFilter.hx", "typeFromOperator"}, new String[]{"lineNumber"}, new double[]{298.0}));
        return ABTFilterType.ABTFilterTypeUnknown;
    }

    public void fromJSON(Object object) {
        String string = Runtime.toString(Reflect.field(object, kABTFilterKeyProperty));
        if (string != null) {
            this.property = string;
            this.propertySource = ABTFilterPropertySource.ABTFilterPropertySourceDevice;
        } else {
            string = Runtime.toString(Reflect.field(object, kABTFilterKeyUserAttribute));
            if (string != null) {
                this.property = string;
                this.propertySource = ABTFilterPropertySource.ABTFilterPropertySourceUser;
            } else {
                string = Runtime.toString(Reflect.field(object, kABTFilterKeyPrefixedAttribute));
                if (string != null) {
                    this.property = string;
                    this.propertySource = ABTFilterPropertySource.ABTFilterPropertySourcePrefixed;
                }
            }
        }
        this.filterOperator = ABTFilter.operatorFromString(Runtime.toString(Reflect.field(object, kABTFilterKeyOperator)));
        this.filterType = ABTFilter.filterForTypeFromJSON(object);
        if (this.filterType == ABTFilterType.ABTFilterTypeUnknown) {
            ABTLogger.w("Unknown filter type: setting value without type checking.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.filter.ABTFilter", "src/apptimize/filter/ABTFilter.hx", "fromJSON"}, new String[]{"lineNumber"}, new double[]{149.0}));
            this.value = Reflect.field(object, kABTFilterKeyValue);
        }
        this.callServerURLKey = Runtime.toString(Reflect.field(object, kABTFilterKeyCallURLKey));
    }

    public boolean isSupportedOperator(String string) {
        return ABTFilter.operatorFromString(string) != ABTFilterOperator.ABTFilterOperatorUnknown;
    }

    public boolean isSupportedProperty(ABTFilterEnvironment aBTFilterEnvironment, String string, ABTFilterPropertySource aBTFilterPropertySource) {
        boolean bl;
        boolean bl2 = bl = null != aBTFilterEnvironment.valueForProperty(string, aBTFilterPropertySource);
        if (!bl) {
            ABTLogger.d("Property \"" + string + "\" not found which is expected by a filter.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.filter.ABTFilter", "src/apptimize/filter/ABTFilter.hx", "isSupportedProperty"}, new String[]{"lineNumber"}, new double[]{166.0}));
        }
        return bl;
    }

    public String currentDeviceValue(ABTFilterEnvironment aBTFilterEnvironment) {
        return aBTFilterEnvironment.valueForProperty(this.property, this.propertySource);
    }

    public boolean hasSupportedProperty(ABTFilterEnvironment aBTFilterEnvironment) {
        return this.isSupportedProperty(aBTFilterEnvironment, this.property, this.propertySource);
    }

    public ABTFilterResult filterMatchesEnvironment(ABTFilterEnvironment aBTFilterEnvironment) {
        ABTLogger.e("Unknown filter type. Filter match is unknown.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.filter.ABTFilter", "src/apptimize/filter/ABTFilter.hx", "filterMatchesEnvironment"}, new String[]{"lineNumber"}, new double[]{181.0}));
        return ABTFilterResult.ABTFilterResultUnknown;
    }

    public Array<String> getUrlKeys() {
        if (this.callServerURLKey == null) {
            return new Array<String>(new String[0]);
        }
        return new Array<String>(new String[]{this.callServerURLKey});
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 111972721: {
                    if (!string.equals("value")) break;
                    bl2 = false;
                    this.value = d;
                    return d;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -1383675631: {
                    if (!string.equals("callServerURLKey")) break;
                    bl2 = false;
                    this.callServerURLKey = Runtime.toString(object);
                    return object;
                }
                case -993141291: {
                    if (!string.equals("property")) break;
                    bl2 = false;
                    this.property = Runtime.toString(object);
                    return object;
                }
                case -702128068: {
                    if (!string.equals("filterOperator")) break;
                    bl2 = false;
                    this.filterOperator = (ABTFilterOperator)((Object)object);
                    return object;
                }
                case -1883718064: {
                    if (!string.equals("propertySource")) break;
                    bl2 = false;
                    this.propertySource = (ABTFilterPropertySource)((Object)object);
                    return object;
                }
                case -1553050926: {
                    if (!string.equals("filterType")) break;
                    bl2 = false;
                    this.filterType = (ABTFilterType)((Object)object);
                    return object;
                }
                case 111972721: {
                    if (!string.equals("value")) break;
                    bl2 = false;
                    this.value = object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 866407373: {
                    if (!string.equals("getUrlKeys")) break;
                    bl4 = false;
                    return new Closure(this, "getUrlKeys");
                }
                case -993141291: {
                    if (!string.equals("property")) break;
                    bl4 = false;
                    return this.property;
                }
                case -1703003016: {
                    if (!string.equals("filterMatchesEnvironment")) break;
                    bl4 = false;
                    return new Closure(this, "filterMatchesEnvironment");
                }
                case -1883718064: {
                    if (!string.equals("propertySource")) break;
                    bl4 = false;
                    return this.propertySource;
                }
                case 411335977: {
                    if (!string.equals("hasSupportedProperty")) break;
                    bl4 = false;
                    return new Closure(this, "hasSupportedProperty");
                }
                case 111972721: {
                    if (!string.equals("value")) break;
                    bl4 = false;
                    return this.value;
                }
                case 1961819522: {
                    if (!string.equals("currentDeviceValue")) break;
                    bl4 = false;
                    return new Closure(this, "currentDeviceValue");
                }
                case -1553050926: {
                    if (!string.equals("filterType")) break;
                    bl4 = false;
                    return this.filterType;
                }
                case 1813542041: {
                    if (!string.equals("isSupportedProperty")) break;
                    bl4 = false;
                    return new Closure(this, "isSupportedProperty");
                }
                case -702128068: {
                    if (!string.equals("filterOperator")) break;
                    bl4 = false;
                    return this.filterOperator;
                }
                case -1988837528: {
                    if (!string.equals("isSupportedOperator")) break;
                    bl4 = false;
                    return new Closure(this, "isSupportedOperator");
                }
                case -1383675631: {
                    if (!string.equals("callServerURLKey")) break;
                    bl4 = false;
                    return this.callServerURLKey;
                }
                case -1244981358: {
                    if (!string.equals("fromJSON")) break;
                    bl4 = false;
                    return new Closure(this, "fromJSON");
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 111972721: {
                    if (!string.equals("value")) break;
                    bl3 = false;
                    return Runtime.toDouble(this.value);
                }
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 866407373: {
                    if (!string.equals("getUrlKeys")) break;
                    bl = false;
                    return this.getUrlKeys();
                }
                case -1244981358: {
                    if (!string.equals("fromJSON")) break;
                    bl = false;
                    this.fromJSON(objectArray[0]);
                    break;
                }
                case -1703003016: {
                    if (!string.equals("filterMatchesEnvironment")) break;
                    bl = false;
                    return this.filterMatchesEnvironment((ABTFilterEnvironment)objectArray[0]);
                }
                case -1988837528: {
                    if (!string.equals("isSupportedOperator")) break;
                    bl = false;
                    return this.isSupportedOperator(Runtime.toString(objectArray[0]));
                }
                case 411335977: {
                    if (!string.equals("hasSupportedProperty")) break;
                    bl = false;
                    return this.hasSupportedProperty((ABTFilterEnvironment)objectArray[0]);
                }
                case 1813542041: {
                    if (!string.equals("isSupportedProperty")) break;
                    bl = false;
                    return this.isSupportedProperty((ABTFilterEnvironment)objectArray[0], Runtime.toString(objectArray[1]), (ABTFilterPropertySource)((Object)objectArray[2]));
                }
                case 1961819522: {
                    if (!string.equals("currentDeviceValue")) break;
                    bl = false;
                    return this.currentDeviceValue((ABTFilterEnvironment)objectArray[0]);
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("callServerURLKey");
        array.push("filterOperator");
        array.push("filterType");
        array.push("value");
        array.push("propertySource");
        array.push("property");
        super.__hx_getFields(array);
    }
}

