/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.support.persistence;

import com.apptimize.ABTLogger;
import com.apptimize.Apptimize;
import com.apptimize.support.persistence.ABTPICacheStorage;
import com.apptimize.support.persistence.ABTPIDiskStorage;
import com.apptimize.support.persistence.ABTPISmartStorage;
import com.apptimize.support.persistence.ABTPersistence_loadFromHighLatency_171__Fun;
import com.apptimize.support.persistence.ABTPersistentInterface;
import com.apptimize.support.properties.ABTConfigProperties;
import com.apptimize.util.ABTDataLock;
import haxe.Exception;
import haxe.NativeStackTrace;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Std;

public class ABTPersistence
extends HxObject {
    public static int LOW_LATENCY = 0;
    public static int HIGH_LATENCY = 1;
    public static int ALL_LATENCY = 2;
    public static String kMetadataKey = "METADATA_KEY";
    public static String kUserIDKey = "USER_ID_KEY";
    public static String kAnonymousGuidKey = "ANONYMOUS_GUID_KEY";
    public static String kCustomPropertiesKey = "CUSTOM_PROPERTIES_KEY";
    public static String kInternalPropertiesKey = "INTERNAL_PROPERTIES_KEY";
    public static String kResultLogsKey = "RESULT_LOGS_KEY";
    public static String kResultPostsKey = "RESULT_POSTS_KEY";
    public static String kResultPostsListKey = "RESULT_POSTS_LIST_KEY";
    public static String kResultEntrySequenceKey = "RESULT_ENTRY_SEQUENCE_KEY";
    public static String kResultEntryTimestampKey = "RESULT_ENTRY_TIMESTAMP_KEY";
    public static String kApptimizeVersionKey = "APPTIMIZE_VERSION_KEY";
    public static String kLockAccessKey = "LOCK_ACCESS_KEY";
    public static String kPostManagementKey = "POST_MANAGEMENT_KEY";
    public static String kResultLastSubmitTimeKey = "RESULT_LAST_SUBMIT_TIME_KEY";
    public static String kMetadataLastCheckTimeKey = "METADATA_LAST_CHECK_TIME_KEY";
    public static String kDisabledVersions = "DISABLED_VERSIONS_KEY";
    public static ABTPersistentInterface _persistentInterface;
    public static boolean _isFlushing;

    public ABTPersistence(EmptyObject emptyObject) {
    }

    public ABTPersistence() {
        ABTPersistence.__hx_ctor_apptimize_support_persistence_ABTPersistence(this);
    }

    protected static void __hx_ctor_apptimize_support_persistence_ABTPersistence(ABTPersistence aBTPersistence) {
    }

    public static ABTPersistentInterface getPersistentInterface() {
        if (_persistentInterface == null) {
            if (ABTConfigProperties.sharedInstance().isPropertyAvailable(ABTConfigProperties.STORAGE_TYPE_KEY) && Runtime.eq(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.STORAGE_TYPE_KEY), "memory")) {
                _persistentInterface = new ABTPICacheStorage();
                return _persistentInterface;
            }
            _persistentInterface = new ABTPISmartStorage(new ABTPICacheStorage(), new ABTPIDiskStorage());
        }
        return _persistentInterface;
    }

    public static void shutdown() {
        _persistentInterface = null;
    }

    public static void loadFromHighLatency(Object object) {
        Array<String> array = new Array<String>(new String[]{kMetadataKey, kUserIDKey, kAnonymousGuidKey, kCustomPropertiesKey, kInternalPropertiesKey, kResultLogsKey, kResultPostsKey, kResultEntrySequenceKey, kResultEntryTimestampKey, kApptimizeVersionKey, kLockAccessKey, kPostManagementKey, kResultLastSubmitTimeKey, kMetadataLastCheckTimeKey, kResultPostsListKey});
        Array<String> array2 = array.copy();
        ABTPersistence_loadFromHighLatency_171__Fun aBTPersistence_loadFromHighLatency_171__Fun = new ABTPersistence_loadFromHighLatency_171__Fun(array2, object);
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            for (int i = 0; i < array.length; ++i) {
                String string = array.__get(i);
                ABTPersistence.getPersistentInterface().sync(string, HIGH_LATENCY, LOW_LATENCY, aBTPersistence_loadFromHighLatency_171__Fun);
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object2 = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object2);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
    }

    public static void saveToHighLatency() {
        Array<String> array = new Array<String>(new String[]{kMetadataKey, kUserIDKey, kAnonymousGuidKey, kCustomPropertiesKey, kInternalPropertiesKey, kResultLogsKey, kResultPostsKey, kResultEntrySequenceKey, kResultEntryTimestampKey, kApptimizeVersionKey, kLockAccessKey, kPostManagementKey, kResultLastSubmitTimeKey, kMetadataLastCheckTimeKey, kResultPostsListKey});
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            for (int i = 0; i < array.length; ++i) {
                String string = array.__get(i);
                ABTPersistence.getPersistentInterface().sync(string, LOW_LATENCY, HIGH_LATENCY, null);
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
    }

    public static void clear() {
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            ABTPersistence.getPersistentInterface().clear(ALL_LATENCY);
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
    }

    public static void saveString(String string, String string2, Object object, Object object2) {
        boolean bl = Runtime.eq(object2, null) ? false : Runtime.toBool((Boolean)object2);
        int n = Runtime.eq(object, null) ? 0 : Runtime.toInt(object);
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            try {
                ABTPersistence.getPersistentInterface().save(string, string2, n, bl);
            }
            catch (Throwable throwable) {
                NativeStackTrace.exception.set(throwable);
                Object object3 = Exception.caught(throwable).unwrap();
                if (!_isFlushing) {
                    ABTLogger.e("Unable to store \"" + string + "\" to persistent storage. Submitting all pending results data. Error: " + Std.string(object3), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.support.persistence.ABTPersistence", "src/apptimize/support/persistence/ABTPersistence.hx", "saveString"}, new String[]{"lineNumber"}, new double[]{215.0}));
                }
                ABTPersistence.flushTracking();
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object4 = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object4);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
    }

    public static void saveObject(String string, Object object, Object object2, Object object3) {
        boolean bl = Runtime.eq(object3, null) ? false : Runtime.toBool((Boolean)object3);
        int n = Runtime.eq(object2, null) ? 0 : Runtime.toInt(object2);
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            try {
                ABTPersistence.getPersistentInterface().saveObject(string, object, n, bl);
            }
            catch (Throwable throwable) {
                NativeStackTrace.exception.set(throwable);
                Object object4 = Exception.caught(throwable).unwrap();
                if (!_isFlushing) {
                    ABTLogger.e("Unable to store \"" + string + "\" to persistent storage. Submitting all pending results data. Error: " + Std.string(object4), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.support.persistence.ABTPersistence", "src/apptimize/support/persistence/ABTPersistence.hx", "saveObject"}, new String[]{"lineNumber"}, new double[]{229.0}));
                }
                ABTPersistence.flushTracking();
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object5 = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object5);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
    }

    public static void flushTracking() {
        if (_isFlushing) {
            return;
        }
        _isFlushing = true;
        try {
            Apptimize.flushTracking();
            _isFlushing = false;
        }
        catch (Throwable throwable) {
            Exception exception = Exception.caught(throwable);
            _isFlushing = false;
            ABTLogger.e("Error on flushing pending results data " + Std.string(exception), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.support.persistence.ABTPersistence", "src/apptimize/support/persistence/ABTPersistence.hx", "flushTracking"}, new String[]{"lineNumber"}, new double[]{247.0}));
        }
    }

    public static String loadString(String string, Object object) {
        int n = Runtime.eq(object, null) ? 0 : Runtime.toInt(object);
        String string2 = null;
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            try {
                string2 = ABTPersistence.getPersistentInterface().load(string, n, null);
            }
            catch (Throwable throwable) {
                NativeStackTrace.exception.set(throwable);
                Object object2 = Exception.caught(throwable).unwrap();
                ABTLogger.e("Unable to retrieve \"" + string + "\" from persistent storage. Error: " + Std.string(object2), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.support.persistence.ABTPersistence", "src/apptimize/support/persistence/ABTPersistence.hx", "loadString"}, new String[]{"lineNumber"}, new double[]{261.0}));
                return null;
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object3 = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object3);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
        return string2;
    }

    public static Object loadObject(String string, Object object) {
        int n = Runtime.eq(object, null) ? 0 : Runtime.toInt(object);
        Object object2 = null;
        ABTDataLock.SYSTEM_DATA_LOCK.acquire();
        try {
            try {
                object2 = ABTPersistence.getPersistentInterface().loadObject(string, n, null);
            }
            catch (Throwable throwable) {
                NativeStackTrace.exception.set(throwable);
                Object object3 = Exception.caught(throwable).unwrap();
                ABTLogger.e("Unable to retrieve \"" + string + "\" from persistent storage. Error: " + Std.string(object3), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.support.persistence.ABTPersistence", "src/apptimize/support/persistence/ABTPersistence.hx", "loadObject"}, new String[]{"lineNumber"}, new double[]{274.0}));
                return null;
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object4 = Exception.caught(throwable).unwrap();
            ABTDataLock.SYSTEM_DATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object4);
        }
        ABTDataLock.SYSTEM_DATA_LOCK.release();
        return object2;
    }

    static {
        _isFlushing = false;
    }
}

