/*
 * Decompiled with CFR 0.152.
 */
package hx.concurrent.executor;

import haxe.Exception;
import haxe.lang.EmptyObject;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Date;
import hx.concurrent.executor.Schedule;

public class ScheduleTools
extends HxObject {
    public ScheduleTools(EmptyObject emptyObject) {
    }

    public ScheduleTools() {
        ScheduleTools.__hx_ctor_hx_concurrent_executor_ScheduleTools(this);
    }

    protected static void __hx_ctor_hx_concurrent_executor_ScheduleTools(ScheduleTools scheduleTools) {
    }

    public static Schedule applyDefaults(Schedule schedule) {
        switch (schedule.index) {
            case 0: {
                Object object = schedule.params[0];
                if (!Runtime.eq(object, null)) break;
                return Schedule.ONCE(0);
            }
            case 1: {
                int n = Runtime.toInt(schedule.params[0]);
                Object object = schedule.params[1];
                if (!Runtime.eq(object, null)) break;
                return Schedule.FIXED_DELAY(n, 0);
            }
            case 2: {
                int n = Runtime.toInt(schedule.params[0]);
                Object object = schedule.params[1];
                if (!Runtime.eq(object, null)) break;
                return Schedule.FIXED_RATE(n, 0);
            }
            case 3: {
                Object object = schedule.params[0];
                Object object2 = schedule.params[1];
                if (!Runtime.eq(object, null) && !Runtime.eq(object2, null)) break;
                return Schedule.HOURLY(Runtime.eq(object, null) ? Integer.valueOf(0) : object, Runtime.eq(object2, null) ? Integer.valueOf(0) : object2);
            }
            case 4: {
                Object object = schedule.params[0];
                Object object3 = schedule.params[1];
                Object object4 = schedule.params[2];
                if (!Runtime.eq(object, null) && !Runtime.eq(object3, null) && !Runtime.eq(object4, null)) break;
                return Schedule.DAILY(Runtime.eq(object, null) ? Integer.valueOf(0) : object, Runtime.eq(object3, null) ? Integer.valueOf(0) : object3, Runtime.eq(object4, null) ? Integer.valueOf(0) : object4);
            }
            case 5: {
                Object object = schedule.params[0];
                Object object5 = schedule.params[1];
                Object object6 = schedule.params[2];
                Object object7 = schedule.params[3];
                if (!Runtime.eq(object, null) && !Runtime.eq(object5, null) && !Runtime.eq(object6, null) && !Runtime.eq(object7, null)) break;
                return Schedule.WEEKLY(Runtime.eq(object, null) ? Integer.valueOf(0) : object, Runtime.eq(object5, null) ? Integer.valueOf(0) : object5, Runtime.eq(object6, null) ? Integer.valueOf(0) : object6, Runtime.eq(object7, null) ? Integer.valueOf(0) : object7);
            }
        }
        return schedule;
    }

    public static Schedule assertValid(Schedule schedule) {
        schedule = ScheduleTools.applyDefaults(schedule);
        switch (schedule.index) {
            case 0: {
                Object object = schedule.params[0];
                if (Runtime.toInt(object) >= 0) break;
                throw (RuntimeException)Exception.thrown("[Schedule.ONCE.initialDelayMS] must be >= 0");
            }
            case 1: {
                int n = Runtime.toInt(schedule.params[0]);
                Object object = schedule.params[1];
                if (n <= 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.FIXED_DELAY.intervalMS] must be > 0");
                }
                if (!Runtime.eq(object, null) && Runtime.toInt(object) >= 0) break;
                throw (RuntimeException)Exception.thrown("[Schedule.FIXED_DELAY.initialDelayMS] must be >= 0");
            }
            case 2: {
                int n = Runtime.toInt(schedule.params[0]);
                Object object = schedule.params[1];
                if (n <= 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.FIXED_RATE.intervalMS] must be > 0");
                }
                if (Runtime.toInt(object) >= 0) break;
                throw (RuntimeException)Exception.thrown("[Schedule.FIXED_RATE.initialDelayMS] must be >= 0");
            }
            case 3: {
                Object object = schedule.params[0];
                Object object2 = schedule.params[1];
                if (Runtime.eq(object, null) || Runtime.toInt(object) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.DAILY.minute] must be between >= 0 and <= 59");
                }
                if (!Runtime.eq(object2, null) && Runtime.toInt(object2) >= 0) break;
                throw (RuntimeException)Exception.thrown("[Schedule.DAILY.second] must be between >= 0 and <= 59");
            }
            case 4: {
                Object object = schedule.params[0];
                Object object3 = schedule.params[1];
                Object object4 = schedule.params[2];
                if (Runtime.eq(object, null) || Runtime.toInt(object) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.DAILY.hour] must be between >= 0 and <= 23");
                }
                if (Runtime.eq(object3, null) || Runtime.toInt(object3) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.DAILY.minute] must be between >= 0 and <= 59");
                }
                if (!Runtime.eq(object4, null) && Runtime.toInt(object4) >= 0) break;
                throw (RuntimeException)Exception.thrown("[Schedule.DAILY.second] must be between >= 0 and <= 59");
            }
            case 5: {
                Object object = schedule.params[0];
                Object object5 = schedule.params[1];
                Object object6 = schedule.params[2];
                Object object7 = schedule.params[3];
                if (Runtime.eq(object5, null) || Runtime.toInt(object5) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.hour] must be between >= 0 and <= 23");
                }
                if (Runtime.eq(object6, null) || Runtime.toInt(object6) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.minute] must be between >= 0 and <= 59");
                }
                if (!Runtime.eq(object7, null) && Runtime.toInt(object7) >= 0) break;
                throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.second] must be between >= 0 and <= 59");
            }
        }
        return schedule;
    }

    public static double firstRunAt(Schedule schedule) {
        schedule = ScheduleTools.assertValid(schedule);
        switch (schedule.index) {
            case 0: {
                Object object = schedule.params[0];
                return Runtime.toDouble(Runtime.plus(System.currentTimeMillis(), object));
            }
            case 1: {
                int n = Runtime.toInt(schedule.params[0]);
                Object object = schedule.params[1];
                return Runtime.toDouble(Runtime.plus(System.currentTimeMillis(), object));
            }
            case 2: {
                int n = Runtime.toInt(schedule.params[0]);
                Object object = schedule.params[1];
                return Runtime.toDouble(Runtime.plus(System.currentTimeMillis(), object));
            }
            case 3: {
                Object object = schedule.params[0];
                Object object2 = schedule.params[1];
                double d = System.currentTimeMillis();
                Date date = Date.fromTime(d);
                int n = Runtime.toInt(Runtime.plus(Runtime.toInt(object) * 60, object2));
                int n2 = date.date.get(12) * 60 + date.date.get(13);
                return d + (double)((n - n2) * 1000) + (double)(n2 > n ? 3600000 : 0);
            }
            case 4: {
                Object object = schedule.params[0];
                Object object3 = schedule.params[1];
                Object object4 = schedule.params[2];
                double d = System.currentTimeMillis();
                Date date = Date.fromTime(d);
                int n = Runtime.toInt(Runtime.plus(Runtime.toInt(object) * 60 * 60 + Runtime.toInt(object3) * 60, object4));
                int n3 = date.date.get(11) * 60 * 60 + date.date.get(12) * 60 + date.date.get(13);
                return d + (double)((n - n3) * 1000) + (double)(n3 > n ? 86400000 : 0);
            }
            case 5: {
                Object object = schedule.params[0];
                Object object5 = schedule.params[1];
                Object object6 = schedule.params[2];
                Object object7 = schedule.params[3];
                double d = System.currentTimeMillis();
                Date date = Date.fromTime(d);
                int n = Runtime.toInt(Runtime.plus(Runtime.toInt(object5) * 60 * 60 + Runtime.toInt(object6) * 60, object7));
                int n4 = date.date.get(11) * 60 * 60 + date.date.get(12) * 60 + date.date.get(13);
                int n5 = Runtime.toInt(object);
                if (n5 == date.date.get(7) - 1) {
                    return d + (double)((n - n4) * 1000) + (double)(n4 > n ? 604800000 : 0);
                }
                if (date.date.get(5) < n5) {
                    return d + (double)((n - n4) * 1000) + (double)(86400000 * (n5 - date.date.get(5)));
                }
                return d + (double)((n - n4) * 1000) + (double)(86400000 * (7 - (n5 - date.date.get(5))));
            }
        }
        return 0.0;
    }
}

