/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize.util;

import com.apptimize.util.ABTDataLock;
import com.apptimize.util.ABTDispatch;
import com.apptimize.util.ABTLRUCache_clear_33__Fun;
import com.apptimize.util.ABTLRUCache_insert_33__Fun;
import com.apptimize.util.ABTLRUCache_remove_33__Fun;
import com.apptimize.util.PlatformLock;
import haxe.Exception;
import haxe.NativeStackTrace;
import haxe.Serializer;
import haxe.Unserializer;
import haxe.ds.StringMap;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.Function;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;

public class ABTLRUCache<T>
extends HxObject {
    public volatile int _cacheSize;
    public volatile Array<String> _list;
    public volatile StringMap<T> _map;
    public volatile PlatformLock cacheLock;

    public ABTLRUCache(EmptyObject emptyObject) {
    }

    public ABTLRUCache(int n) {
        ABTLRUCache.__hx_ctor_apptimize_util_ABTLRUCache(this, n);
        Object var2_2 = null;
    }

    protected static <T_c> void __hx_ctor_apptimize_util_ABTLRUCache(ABTLRUCache<T_c> aBTLRUCache, int n) {
        aBTLRUCache.cacheLock = ABTDataLock.getNewLock("ABTLRUCache_lock");
        aBTLRUCache._cacheSize = n;
        aBTLRUCache.clear(null, null);
    }

    public void clear(Function function, ABTDispatch aBTDispatch) {
        this.cacheLock.acquire();
        try {
            if (function != null) {
                Array<String> array = this._list;
                for (int i = 0; i < array.length; ++i) {
                    String string = array.__get(i);
                    Object object = this._map.get(string);
                    ABTLRUCache_clear_33__Fun aBTLRUCache_clear_33__Fun = new ABTLRUCache_clear_33__Fun(object, function);
                    if (aBTDispatch != null) {
                        aBTDispatch.dispatch(aBTLRUCache_clear_33__Fun, 0);
                        continue;
                    }
                    ABTDispatch.dispatchImmediately(aBTLRUCache_clear_33__Fun);
                }
            }
            this._list = new Array();
            this._map = new StringMap();
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            this.cacheLock.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        this.cacheLock.release();
    }

    public boolean hasKey(String string) {
        boolean bl = false;
        this.cacheLock.acquire();
        try {
            bl = this._map.get(string) != null;
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            this.cacheLock.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        this.cacheLock.release();
        return bl;
    }

    public T getValue(String string) {
        Object object = null;
        this.cacheLock.acquire();
        try {
            if (this.hasKey(string)) {
                object = this._map.get(string);
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object2 = Exception.caught(throwable).unwrap();
            this.cacheLock.release();
            throw (RuntimeException)Exception.thrown(object2);
        }
        this.cacheLock.release();
        return (T)object;
    }

    public void remove(String string, Function function, ABTDispatch aBTDispatch) {
        this.cacheLock.acquire();
        try {
            if (!this.hasKey(string)) {
                return;
            }
            if (function != null) {
                Object object = this._map.get(string);
                ABTLRUCache_remove_33__Fun aBTLRUCache_remove_33__Fun = new ABTLRUCache_remove_33__Fun(object, function);
                if (aBTDispatch != null) {
                    aBTDispatch.dispatch(aBTLRUCache_remove_33__Fun, 0);
                } else {
                    ABTDispatch.dispatchImmediately(aBTLRUCache_remove_33__Fun);
                }
            }
            this._list.remove(string);
            this._map.remove(string);
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            this.cacheLock.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        this.cacheLock.release();
    }

    public void insert(String string, T t, Function function, ABTDispatch aBTDispatch) {
        this.cacheLock.acquire();
        try {
            if (this.hasKey(string)) {
                this._map.set(string, t);
                this._list.remove(string);
                this._list.push(string);
            } else {
                this._map.set(string, t);
                this._list.push(string);
                if (this._list.length > this._cacheSize) {
                    String string2 = Runtime.toString(this._list.shift());
                    if (function != null) {
                        Object object = this._map.get(string2);
                        ABTLRUCache_insert_33__Fun aBTLRUCache_insert_33__Fun = new ABTLRUCache_insert_33__Fun(object, function);
                        if (aBTDispatch != null) {
                            aBTDispatch.dispatch(aBTLRUCache_insert_33__Fun, 0);
                        } else {
                            ABTDispatch.dispatchImmediately(aBTLRUCache_insert_33__Fun);
                        }
                    }
                    this._map.remove(string2);
                }
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            this.cacheLock.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        this.cacheLock.release();
    }

    public void hxSerialize(Serializer serializer) {
        StringMap<Object> stringMap = new StringMap<Object>();
        stringMap.set("_cacheSize", this._cacheSize);
        stringMap.set("_list", this._list);
        stringMap.set("_map", this._map);
        StringMap<Object> stringMap2 = stringMap;
        serializer.serialize(stringMap2);
    }

    public void hxUnserialize(Unserializer unserializer) {
        StringMap stringMap = (StringMap)unserializer.unserialize();
        this._cacheSize = Runtime.toInt(stringMap.get("_cacheSize"));
        this._list = (Array)stringMap.get("_list");
        this._map = (StringMap)stringMap.get("_map");
        this.initMissingFields();
    }

    public void didUnserialize() {
        this.initMissingFields();
    }

    public void initMissingFields() {
        if (this.cacheLock == null) {
            this.cacheLock = ABTDataLock.getNewLock("ABTLRUCache_lock");
        }
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -2042532572: {
                    if (!string.equals("_cacheSize")) break;
                    bl2 = false;
                    this._cacheSize = (int)d;
                    return d;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -553822259: {
                    if (!string.equals("cacheLock")) break;
                    bl2 = false;
                    this.cacheLock = (PlatformLock)object;
                    return object;
                }
                case -2042532572: {
                    if (!string.equals("_cacheSize")) break;
                    bl2 = false;
                    this._cacheSize = Runtime.toInt(object);
                    return object;
                }
                case 2938013: {
                    if (!string.equals("_map")) break;
                    bl2 = false;
                    this._map = (StringMap)object;
                    return object;
                }
                case 91056509: {
                    if (!string.equals("_list")) break;
                    bl2 = false;
                    this._list = (Array)object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -206156657: {
                    if (!string.equals("initMissingFields")) break;
                    bl4 = false;
                    return new Closure(this, "initMissingFields");
                }
                case -2042532572: {
                    if (!string.equals("_cacheSize")) break;
                    bl4 = false;
                    return this._cacheSize;
                }
                case 1427399272: {
                    if (!string.equals("didUnserialize")) break;
                    bl4 = false;
                    return new Closure(this, "didUnserialize");
                }
                case 91056509: {
                    if (!string.equals("_list")) break;
                    bl4 = false;
                    return this._list;
                }
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxUnserialize");
                }
                case 2938013: {
                    if (!string.equals("_map")) break;
                    bl4 = false;
                    return this._map;
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl4 = false;
                    return new Closure(this, "hxSerialize");
                }
                case -553822259: {
                    if (!string.equals("cacheLock")) break;
                    bl4 = false;
                    return this.cacheLock;
                }
                case -1183792455: {
                    if (!string.equals("insert")) break;
                    bl4 = false;
                    return new Closure(this, "insert");
                }
                case 94746189: {
                    if (!string.equals("clear")) break;
                    bl4 = false;
                    return new Closure(this, "clear");
                }
                case -934610812: {
                    if (!string.equals("remove")) break;
                    bl4 = false;
                    return new Closure(this, "remove");
                }
                case -1224452763: {
                    if (!string.equals("hasKey")) break;
                    bl4 = false;
                    return new Closure(this, "hasKey");
                }
                case 1967798203: {
                    if (!string.equals("getValue")) break;
                    bl4 = false;
                    return new Closure(this, "getValue");
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -2042532572: {
                    if (!string.equals("_cacheSize")) break;
                    bl3 = false;
                    return this._cacheSize;
                }
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -206156657: {
                    if (!string.equals("initMissingFields")) break;
                    bl = false;
                    this.initMissingFields();
                    break;
                }
                case 94746189: {
                    if (!string.equals("clear")) break;
                    bl = false;
                    this.clear((Function)(objectArray.length > 0 ? objectArray[0] : null), (ABTDispatch)(objectArray.length > 1 ? objectArray[1] : null));
                    break;
                }
                case 1427399272: {
                    if (!string.equals("didUnserialize")) break;
                    bl = false;
                    this.didUnserialize();
                    break;
                }
                case -1224452763: {
                    if (!string.equals("hasKey")) break;
                    bl = false;
                    return this.hasKey(Runtime.toString(objectArray[0]));
                }
                case -976255689: {
                    if (!string.equals("hxUnserialize")) break;
                    bl = false;
                    this.hxUnserialize((Unserializer)objectArray[0]);
                    break;
                }
                case 1967798203: {
                    if (!string.equals("getValue")) break;
                    bl = false;
                    return this.getValue(Runtime.toString(objectArray[0]));
                }
                case 1419324336: {
                    if (!string.equals("hxSerialize")) break;
                    bl = false;
                    this.hxSerialize((Serializer)objectArray[0]);
                    break;
                }
                case -934610812: {
                    if (!string.equals("remove")) break;
                    bl = false;
                    this.remove(Runtime.toString(objectArray[0]), (Function)(objectArray.length > 1 ? objectArray[1] : null), (ABTDispatch)(objectArray.length > 2 ? objectArray[2] : null));
                    break;
                }
                case -1183792455: {
                    if (!string.equals("insert")) break;
                    bl = false;
                    this.insert(Runtime.toString(objectArray[0]), objectArray[1], (Function)(objectArray.length > 2 ? objectArray[2] : null), (ABTDispatch)(objectArray.length > 3 ? objectArray[3] : null));
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("cacheLock");
        array.push("_map");
        array.push("_list");
        array.push("_cacheSize");
        super.__hx_getFields(array);
    }
}

