/*
 * Decompiled with CFR 0.152.
 */
package haxe;

import haxe.Exception;
import haxe.ds.IntMap;
import haxe.ds.List;
import haxe.ds.ObjectMap;
import haxe.ds.StringMap;
import haxe.ds._IntMap.IntMapKeyIterator;
import haxe.ds._List.ListNode;
import haxe.ds._StringMap.StringMapKeyIterator;
import haxe.io.Bytes;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.lang.StringExt;
import haxe.root.Array;
import haxe.root.Date;
import haxe.root.Reflect;
import haxe.root.Std;
import haxe.root.StringBuf;
import haxe.root.StringTools;
import haxe.root.Type;
import haxe.root.ValueType;

public class Serializer
extends HxObject {
    public static boolean USE_CACHE = false;
    public static boolean USE_ENUM_INDEX = false;
    public static String BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%:";
    public static Object[] BASE64_CODES = null;
    public StringBuf buf;
    public Array cache;
    public StringMap<Object> shash;
    public int scount;
    public boolean useCache;
    public boolean useEnumIndex;

    public Serializer(EmptyObject emptyObject) {
    }

    public Serializer() {
        Serializer.__hx_ctor_haxe_Serializer(this);
    }

    protected static void __hx_ctor_haxe_Serializer(Serializer serializer) {
        serializer.buf = new StringBuf();
        serializer.cache = new Array();
        serializer.useCache = USE_CACHE;
        serializer.useEnumIndex = USE_ENUM_INDEX;
        serializer.shash = new StringMap();
        serializer.scount = 0;
    }

    public String toString() {
        return this.buf.toString();
    }

    public void serializeString(String string) {
        Object object = this.shash.get(string);
        if (!Runtime.eq(object, null)) {
            this.buf.add(Runtime.toString("R"));
            Object var3_3 = null;
            this.buf.add(object);
            Object var4_5 = null;
            return;
        }
        this.shash.set(string, this.scount++);
        this.buf.add(Runtime.toString("y"));
        Object var3_4 = null;
        string = StringTools.urlEncode(string);
        this.buf.add(string.length());
        Object var4_6 = null;
        this.buf.add(Runtime.toString(":"));
        Object var5_7 = null;
        this.buf.add(Runtime.toString(string));
        Object var6_8 = null;
    }

    public boolean serializeRef(Object object) {
        int n = 0;
        int n2 = this.cache.length;
        while (n < n2) {
            int n3;
            if (!Runtime.eq(this.cache.__get(n3 = n++), object)) continue;
            this.buf.add(Runtime.toString("r"));
            Object var5_5 = null;
            this.buf.add(n3);
            Object var6_6 = null;
            return true;
        }
        this.cache.push(object);
        return false;
    }

    public void serializeFields(Object object) {
        Array<String> array = Reflect.fields(object);
        for (int i = 0; i < array.length; ++i) {
            String string = array.__get(i);
            this.serializeString(string);
            this.serialize(Reflect.field(object, string));
        }
        this.buf.add(Runtime.toString("g"));
        Object var2_3 = null;
    }

    public void serialize(Object object) {
        ValueType valueType = Type.typeof(object);
        switch (valueType.index) {
            case 0: {
                this.buf.add(Runtime.toString("n"));
                Object var3_3 = null;
                break;
            }
            case 1: {
                int n = Runtime.toInt(object);
                if (n == 0) {
                    this.buf.add(Runtime.toString("z"));
                    Object var4_11 = null;
                    return;
                }
                this.buf.add(Runtime.toString("i"));
                Object var4_12 = null;
                this.buf.add(n);
                Object var5_16 = null;
                break;
            }
            case 2: {
                double d = Runtime.toDouble(object);
                if (Double.isNaN(d)) {
                    this.buf.add(Runtime.toString("k"));
                    Object var5_17 = null;
                    break;
                }
                if (!Runtime.isFinite(d)) {
                    this.buf.add(Runtime.toString(d < 0.0 ? "m" : "p"));
                    Object var5_18 = null;
                    break;
                }
                this.buf.add(Runtime.toString("d"));
                Object var5_19 = null;
                this.buf.add(d);
                Object var8_31 = null;
                break;
            }
            case 3: {
                this.buf.add(Runtime.toString(Runtime.toBool((Boolean)object) ? "t" : "f"));
                Object var3_5 = null;
                break;
            }
            case 4: {
                if (object instanceof Class) {
                    String string = Type.getClassName((Class)object);
                    this.buf.add(Runtime.toString("A"));
                    Object var4_13 = null;
                    this.serializeString(string);
                    break;
                }
                if (object instanceof Class) {
                    this.buf.add(Runtime.toString("B"));
                    Object var3_7 = null;
                    this.serializeString(Type.getEnumName((Class)object));
                    break;
                }
                if (this.useCache && this.serializeRef(object)) {
                    return;
                }
                this.buf.add(Runtime.toString("o"));
                Object var3_8 = null;
                this.serializeFields(object);
                break;
            }
            case 5: {
                throw (RuntimeException)Exception.thrown("Cannot serialize function");
            }
            case 6: {
                Class clazz = (Class)valueType.params[0];
                if (clazz == String.class) {
                    this.serializeString(Runtime.toString(object));
                    return;
                }
                if (this.useCache && this.serializeRef(object)) {
                    return;
                }
                Class clazz2 = clazz;
                if (clazz2 == Array.class) {
                    int n = 0;
                    this.buf.add(Runtime.toString("a"));
                    Object var8_32 = null;
                    int n2 = Runtime.toInt(Runtime.getField(object, "length", true));
                    int n3 = 0;
                    int n4 = n2;
                    while (n3 < n4) {
                        int n5;
                        if (Runtime.callField(object, "__get", new Object[]{n5 = n3++}) == null) {
                            ++n;
                            continue;
                        }
                        if (n > 0) {
                            Object var13_70;
                            if (n == 1) {
                                this.buf.add(Runtime.toString("n"));
                                var13_70 = null;
                            } else {
                                this.buf.add(Runtime.toString("u"));
                                var13_70 = null;
                                this.buf.add(n);
                                Object var14_72 = null;
                            }
                            n = 0;
                        }
                        this.serialize(Runtime.callField(object, "__get", new Object[]{n5}));
                    }
                    if (n > 0) {
                        if (n == 1) {
                            this.buf.add(Runtime.toString("n"));
                            Object var10_52 = null;
                        } else {
                            this.buf.add(Runtime.toString("u"));
                            Object var10_53 = null;
                            this.buf.add(n);
                            Object var11_62 = null;
                        }
                    }
                    this.buf.add(Runtime.toString("h"));
                    Object var10_54 = null;
                    break;
                }
                if (clazz2 == Date.class) {
                    Date date = (Date)object;
                    this.buf.add(Runtime.toString("v"));
                    Object var8_33 = null;
                    this.buf.add(Double.valueOf(date.date.getTimeInMillis()));
                    Object var9_42 = null;
                    break;
                }
                if (clazz2 == IntMap.class) {
                    this.buf.add(Runtime.toString("q"));
                    Object var5_22 = null;
                    IntMap intMap = (IntMap)object;
                    IntMapKeyIterator intMapKeyIterator = new IntMapKeyIterator(intMap);
                    while (Runtime.toBool((Boolean)Runtime.callField(intMapKeyIterator, "hasNext", null))) {
                        int n = Runtime.toInt(Runtime.callField(intMapKeyIterator, "next", null));
                        this.buf.add(Runtime.toString(":"));
                        Object var11_63 = null;
                        this.buf.add(n);
                        Object var12_68 = null;
                        this.serialize(intMap.get(n));
                    }
                    this.buf.add(Runtime.toString("h"));
                    intMapKeyIterator = null;
                    break;
                }
                if (clazz2 == List.class) {
                    this.buf.add(Runtime.toString("l"));
                    Object var5_23 = null;
                    List list = (List)object;
                    ListNode listNode = list.h;
                    while (listNode != null) {
                        Object t = listNode.item;
                        listNode = listNode.next;
                        Object t2 = t;
                        this.serialize(t2);
                    }
                    this.buf.add(Runtime.toString("h"));
                    listNode = null;
                    break;
                }
                if (clazz2 == ObjectMap.class) {
                    this.buf.add(Runtime.toString("M"));
                    Object var5_24 = null;
                    ObjectMap objectMap = (ObjectMap)object;
                    Object object2 = objectMap.keys();
                    while (Runtime.toBool((Boolean)Runtime.callField(object2, "hasNext", null))) {
                        Object object3 = Runtime.callField(object2, "next", null);
                        this.serialize(object3);
                        this.serialize(objectMap.get(object3));
                    }
                    this.buf.add(Runtime.toString("h"));
                    object2 = null;
                    break;
                }
                if (clazz2 == StringMap.class) {
                    this.buf.add(Runtime.toString("b"));
                    Object var5_25 = null;
                    StringMap stringMap = (StringMap)object;
                    StringMapKeyIterator stringMapKeyIterator = new StringMapKeyIterator(stringMap);
                    while (Runtime.toBool((Boolean)Runtime.callField(stringMapKeyIterator, "hasNext", null))) {
                        String string = Runtime.toString(Runtime.callField(stringMapKeyIterator, "next", null));
                        this.serializeString(string);
                        this.serialize(stringMap.get(string));
                    }
                    this.buf.add(Runtime.toString("h"));
                    stringMapKeyIterator = null;
                    break;
                }
                if (clazz2 == Bytes.class) {
                    int n;
                    int n6;
                    Bytes bytes = (Bytes)object;
                    this.buf.add(Runtime.toString("s"));
                    Object var8_38 = null;
                    this.buf.add((int)Math.ceil((double)(bytes.length * 8) / 6.0));
                    Object var9_47 = null;
                    this.buf.add(Runtime.toString(":"));
                    Object var10_59 = null;
                    int n7 = 0;
                    int n8 = bytes.length - 2;
                    Object[] objectArray = BASE64_CODES;
                    if (objectArray == null) {
                        Object[] objectArray2 = new Object[BASE64.length()];
                        objectArray = objectArray2;
                        n6 = 0;
                        n = BASE64.length();
                        while (n6 < n) {
                            int n9 = n6++;
                            objectArray[n9] = StringExt.charCodeAt(BASE64, n9);
                        }
                        BASE64_CODES = objectArray;
                    }
                    while (n7 < n8) {
                        int n10 = bytes.b[n7++] & 0xFF;
                        n6 = bytes.b[n7++] & 0xFF;
                        n = bytes.b[n7++] & 0xFF;
                        this.buf.addChar(Runtime.toInt(objectArray[n10 >> 2]));
                        this.buf.addChar(Runtime.toInt(objectArray[(n10 << 4 | n6 >> 4) & 0x3F]));
                        this.buf.addChar(Runtime.toInt(objectArray[(n6 << 2 | n >> 6) & 0x3F]));
                        this.buf.addChar(Runtime.toInt(objectArray[n & 0x3F]));
                    }
                    if (n7 == n8) {
                        int n11 = bytes.b[n7++] & 0xFF;
                        n6 = bytes.b[n7++] & 0xFF;
                        this.buf.addChar(Runtime.toInt(objectArray[n11 >> 2]));
                        this.buf.addChar(Runtime.toInt(objectArray[(n11 << 4 | n6 >> 4) & 0x3F]));
                        this.buf.addChar(Runtime.toInt(objectArray[n6 << 2 & 0x3F]));
                        break;
                    }
                    if (n7 != n8 + 1) break;
                    int n12 = bytes.b[n7++] & 0xFF;
                    this.buf.addChar(Runtime.toInt(objectArray[n12 >> 2]));
                    this.buf.addChar(Runtime.toInt(objectArray[n12 << 4 & 0x3F]));
                    break;
                }
                if (this.useCache) {
                    this.cache.pop();
                }
                if (Reflect.hasField(object, "hxSerialize")) {
                    this.buf.add(Runtime.toString("C"));
                    Object var5_27 = null;
                    this.serializeString(Type.getClassName(clazz));
                    if (this.useCache) {
                        this.cache.push(object);
                    }
                    Object object4 = Runtime.callField(object, "hxSerialize", new Object[]{this});
                    this.buf.add(Runtime.toString("g"));
                    Object var9_48 = null;
                    break;
                }
                this.buf.add(Runtime.toString("c"));
                Object var5_28 = null;
                this.serializeString(Type.getClassName(clazz));
                if (this.useCache) {
                    this.cache.push(object);
                }
                this.serializeFields(object);
                break;
            }
            case 7: {
                Array array;
                Object var5_29;
                Class clazz = (Class)valueType.params[0];
                if (this.useCache) {
                    if (this.serializeRef(object)) {
                        return;
                    }
                    this.cache.pop();
                }
                this.buf.add(Runtime.toString(this.useEnumIndex ? "j" : "w"));
                Object var4_15 = null;
                this.serializeString(Type.getEnumName(clazz));
                if (this.useEnumIndex) {
                    this.buf.add(Runtime.toString(":"));
                    var5_29 = null;
                    this.buf.add(Type.enumIndex(object));
                    array = null;
                } else {
                    this.serializeString(Type.enumConstructor(object));
                }
                this.buf.add(Runtime.toString(":"));
                var5_29 = null;
                array = Type.enumParameters(object);
                if (array != null) {
                    this.buf.add(array.length);
                    Object var9_49 = null;
                    for (int i = 0; i < array.length; ++i) {
                        Object t = array.__get(i);
                        this.serialize(t);
                    }
                } else {
                    this.buf.add(Runtime.toString("0"));
                    Object var9_50 = null;
                }
                if (!this.useCache) break;
                this.cache.push(object);
                break;
            }
            default: {
                throw (RuntimeException)Exception.thrown("Cannot serialize " + Std.string(object));
            }
        }
    }

    @Override
    public double __hx_setField_f(String string, double d, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -907763588: {
                    if (!string.equals("scount")) break;
                    bl2 = false;
                    this.scount = (int)d;
                    return d;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField_f(string, d, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 1284193930: {
                    if (!string.equals("useEnumIndex")) break;
                    bl2 = false;
                    this.useEnumIndex = Runtime.toBool((Boolean)object);
                    return object;
                }
                case 97907: {
                    if (!string.equals("buf")) break;
                    bl2 = false;
                    this.buf = (StringBuf)object;
                    return object;
                }
                case -309504453: {
                    if (!string.equals("useCache")) break;
                    bl2 = false;
                    this.useCache = Runtime.toBool((Boolean)object);
                    return object;
                }
                case 94416770: {
                    if (!string.equals("cache")) break;
                    bl2 = false;
                    this.cache = (Array)object;
                    return object;
                }
                case -907763588: {
                    if (!string.equals("scount")) break;
                    bl2 = false;
                    this.scount = Runtime.toInt(object);
                    return object;
                }
                case 109400065: {
                    if (!string.equals("shash")) break;
                    bl2 = false;
                    this.shash = (StringMap)object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -573479200: {
                    if (!string.equals("serialize")) break;
                    bl4 = false;
                    return new Closure(this, "serialize");
                }
                case 97907: {
                    if (!string.equals("buf")) break;
                    bl4 = false;
                    return this.buf;
                }
                case -7657031: {
                    if (!string.equals("serializeFields")) break;
                    bl4 = false;
                    return new Closure(this, "serializeFields");
                }
                case 94416770: {
                    if (!string.equals("cache")) break;
                    bl4 = false;
                    return this.cache;
                }
                case 861138323: {
                    if (!string.equals("serializeRef")) break;
                    bl4 = false;
                    return new Closure(this, "serializeRef");
                }
                case 109400065: {
                    if (!string.equals("shash")) break;
                    bl4 = false;
                    return this.shash;
                }
                case 375065361: {
                    if (!string.equals("serializeString")) break;
                    bl4 = false;
                    return new Closure(this, "serializeString");
                }
                case -907763588: {
                    if (!string.equals("scount")) break;
                    bl4 = false;
                    return this.scount;
                }
                case -1776922004: {
                    if (!string.equals("toString")) break;
                    bl4 = false;
                    return new Closure(this, "toString");
                }
                case -309504453: {
                    if (!string.equals("useCache")) break;
                    bl4 = false;
                    return this.useCache;
                }
                case 1284193930: {
                    if (!string.equals("useEnumIndex")) break;
                    bl4 = false;
                    return this.useEnumIndex;
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -907763588: {
                    if (!string.equals("scount")) break;
                    bl3 = false;
                    return this.scount;
                }
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -573479200: {
                    if (!string.equals("serialize")) break;
                    bl = false;
                    this.serialize(objectArray[0]);
                    break;
                }
                case -1776922004: {
                    if (!string.equals("toString")) break;
                    bl = false;
                    return this.toString();
                }
                case -7657031: {
                    if (!string.equals("serializeFields")) break;
                    bl = false;
                    this.serializeFields(objectArray[0]);
                    break;
                }
                case 375065361: {
                    if (!string.equals("serializeString")) break;
                    bl = false;
                    this.serializeString(Runtime.toString(objectArray[0]));
                    break;
                }
                case 861138323: {
                    if (!string.equals("serializeRef")) break;
                    bl = false;
                    return this.serializeRef(objectArray[0]);
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("useEnumIndex");
        array.push("useCache");
        array.push("scount");
        array.push("shash");
        array.push("cache");
        array.push("buf");
        super.__hx_getFields(array);
    }
}

