/*
 * Decompiled with CFR 0.152.
 */
package com.apptimize;

import com.apptimize.ABTDataStore_onMetadataLoaded_310__Fun;
import com.apptimize.ABTDataStore_onMetadataReceived_348__Fun;
import com.apptimize.ABTLogger;
import com.apptimize.Apptimize;
import com.apptimize.ApptimizeInternal;
import com.apptimize.VariantInfo;
import com.apptimize.api.ABTApiClient;
import com.apptimize.api.ABTMetadataPoller;
import com.apptimize.api.ABTSecondaryValuesClient;
import com.apptimize.api.ABTUserGuid;
import com.apptimize.events.ABTEventManager;
import com.apptimize.filter.ABTFilterEnvParams;
import com.apptimize.filter.ABTFilterEnvironment;
import com.apptimize.models.ABTHotfixVariant;
import com.apptimize.models.ABTMetadata;
import com.apptimize.models.ABTSdkParameters;
import com.apptimize.models.ABTVariant;
import com.apptimize.models.results.ABTResultEntry;
import com.apptimize.models.results.ABTResultEntryEvent;
import com.apptimize.models.results.ABTResultEntryVariantShown;
import com.apptimize.models.results.ABTResultLog;
import com.apptimize.support.persistence.ABTPersistence;
import com.apptimize.support.properties.ABTApplicationProperties;
import com.apptimize.support.properties.ABTConfigProperties;
import com.apptimize.support.properties.ABTInternalProperties;
import com.apptimize.util.ABTDataLock;
import com.apptimize.util.ABTDispatch;
import com.apptimize.util.ABTLRUCache;
import com.apptimize.util.PlatformLock;
import haxe.Exception;
import haxe.NativeStackTrace;
import haxe.ds.StringMap;
import haxe.format.JsonPrinter;
import haxe.lang.Closure;
import haxe.lang.DynamicObject;
import haxe.lang.EmptyObject;
import haxe.lang.Function;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import haxe.root.Date;
import haxe.root.Std;
import haxe.root.Type;

public class ABTDataStore
extends HxObject {
    public static String appKey;
    public static String serverGuid;
    public static volatile ABTDataStore _instance;
    public static PlatformLock resultsLock;
    public volatile ABTLRUCache<ABTResultLog> resultLogs;
    public volatile StringMap<ABTMetadata> metaDataCache;
    public ABTSecondaryValuesClient newMdFetcher;
    public ABTSecondaryValuesClient propChangeFetcher;
    public volatile ABTDispatch resultDispatchQueue;
    public ABTSdkParameters sdkParameters;

    public ABTDataStore(EmptyObject emptyObject) {
    }

    public ABTDataStore() {
        ABTDataStore.__hx_ctor_apptimize_ABTDataStore(this);
    }

    protected static void __hx_ctor_apptimize_ABTDataStore(ABTDataStore aBTDataStore) {
        aBTDataStore.sdkParameters = new ABTSdkParameters((Object)null);
        aBTDataStore.resultDispatchQueue = new ABTDispatch(Runtime.toString("Results Logging Dispatch Queue"));
        aBTDataStore.resultDispatchQueue.start(null);
        aBTDataStore.newMdFetcher = new ABTSecondaryValuesClient();
        aBTDataStore.propChangeFetcher = new ABTSecondaryValuesClient();
        aBTDataStore.metaDataCache = new StringMap();
    }

    public static ABTDataStore sharedInstance() {
        if (_instance == null) {
            _instance = new ABTDataStore();
        }
        return _instance;
    }

    public static void clear() {
        ABTPersistence.clear();
        _instance = null;
    }

    public static void shutdown() {
        _instance = null;
        appKey = null;
        serverGuid = null;
    }

    public static double _getLastCheckTime() {
        String string = ABTPersistence.loadString(ABTPersistence.kMetadataLastCheckTimeKey, null);
        if (string != null) {
            return Std.parseFloat(string);
        }
        return -10000.0;
    }

    public static void _updateLastCheckTime(double d) {
        ABTPersistence.saveString(ABTPersistence.kMetadataLastCheckTimeKey, Std.string(d), null, null);
    }

    public static boolean _resetCheckTimeIfNeeded() {
        boolean bl = false;
        ABTDataLock.CHECK_TIME_LOCK.acquire();
        try {
            double d = Std.parseFloat(Runtime.toString(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.METADATA_POLLING_INTERVAL_MS_KEY)));
            double d2 = Date.now().date.getTimeInMillis();
            double d3 = d2 - ABTDataStore._getLastCheckTime();
            if (d3 > d) {
                ABTDataStore._updateLastCheckTime(d2);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            ABTDataLock.CHECK_TIME_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        ABTDataLock.CHECK_TIME_LOCK.release();
        return bl;
    }

    public static double _getLastSubmitTime() {
        String string = ABTPersistence.loadString(ABTPersistence.kResultLastSubmitTimeKey, null);
        if (string != null) {
            return Std.parseFloat(string);
        }
        return -10000.0;
    }

    public static void _updateLastSubmitTime(double d) {
        ABTPersistence.saveString(ABTPersistence.kResultLastSubmitTimeKey, Std.string(d), null, null);
    }

    public static String getAppKey() {
        return appKey;
    }

    public static void checkForUpdatedMetaData(Object object) {
        Object object2;
        Object object3 = object2 = Runtime.eq(object, null) ? Boolean.valueOf(false) : object;
        if (ABTDataStore.shouldDisable()) {
            ABTLogger.w("This SDK version disabled; not checking for updated metadata", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "checkForUpdatedMetaData"}, new String[]{"lineNumber"}, new double[]{223.0}));
            return;
        }
        ABTLogger.v("Checking for updated metadata...", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "checkForUpdatedMetaData"}, new String[]{"lineNumber"}, new double[]{226.0}));
        if (Apptimize._isInitialized() && (Runtime.toBool(ABTDataStore._resetCheckTimeIfNeeded()) || Runtime.toBool((Boolean)object2))) {
            ABTApiClient.sharedInstance().downloadMetaDataForKey(ABTDataStore.getAppKey(), ABTDataStore.sharedInstance()._getCurrentEtag(ABTDataStore.getAppKey()));
        }
    }

    public static void _checkForUpdatedMetadataIfNecessary() {
        if (!ABTMetadataPoller.isPolling() && Runtime.compare(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.METADATA_POLLING_INTERVAL_MS_KEY), 0) >= 0) {
            ABTDataStore.checkForUpdatedMetaData(null);
        }
        ABTDataStore.sharedInstance()._submitResultsIfNecessary();
    }

    public static String getServerGUID() {
        if (serverGuid == null) {
            serverGuid = ABTUserGuid.generateUserGuid();
        }
        return serverGuid;
    }

    public static boolean shouldDisable() {
        Array array = (Array)ABTPersistence.loadObject(ABTPersistence.kDisabledVersions, null);
        if (array == null) {
            return false;
        }
        return array.indexOf(Apptimize.getApptimizeSDKVersion(), null) > -1;
    }

    public void initialize() {
        this.resultLogs = (ABTLRUCache)ABTPersistence.loadObject(ABTPersistence.kResultLogsKey, null);
        if (this.resultLogs == null) {
            Object object = ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.RESULTS_CACHE_SIZE_KEY);
            if (Type.getClass(Runtime.toString(object)) == String.class && (object = Std.parseInt(Runtime.toString(object))) == null) {
                ABTLogger.e("Invalid value specified for results_cache_size, defaulting to 10", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "initialize"}, new String[]{"lineNumber"}, new double[]{102.0}));
                object = 10;
            }
            this.resultLogs = new ABTLRUCache(Runtime.toInt(object));
        }
    }

    public boolean hasMetadata(String string) {
        boolean bl = false;
        ABTDataLock.METADATA_LOCK.acquire();
        try {
            bl = this.metaDataCache.exists(string);
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            ABTDataLock.METADATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        ABTDataLock.METADATA_LOCK.release();
        return bl;
    }

    public String _getCurrentEtag(String string) {
        ABTMetadata aBTMetadata = this.getMetaData(string);
        if (aBTMetadata == null) {
            return null;
        }
        return aBTMetadata.getEtag();
    }

    public void loadMetaData(String string) {
        appKey = string;
        this.reloadFromDisk();
        if (!ABTDataStore.shouldDisable() && (ABTDataStore._resetCheckTimeIfNeeded() || Runtime.eq(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.REFRESH_META_DATA_ON_SETUP), true))) {
            ABTApiClient.sharedInstance().downloadMetaDataForKey(string, this._getCurrentEtag(string));
        }
    }

    public boolean _resetSubmitTimeIfNeeded(Object object) {
        boolean bl = Runtime.eq(object, null) ? false : Runtime.toBool((Boolean)object);
        boolean bl2 = false;
        ABTDataLock.CHECK_TIME_LOCK.acquire();
        try {
            int n = this._getMinTimeBetweenPosts(bl);
            double d = Date.now().date.getTimeInMillis();
            double d2 = d - ABTDataStore._getLastSubmitTime();
            if (d2 > (double)n) {
                ABTDataStore._updateLastSubmitTime(d);
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object2 = Exception.caught(throwable).unwrap();
            ABTDataLock.CHECK_TIME_LOCK.release();
            throw (RuntimeException)Exception.thrown(object2);
        }
        ABTDataLock.CHECK_TIME_LOCK.release();
        return bl2;
    }

    public int _getMinTimeBetweenPosts(Object object) {
        boolean bl = Runtime.eq(object, null) ? false : Runtime.toBool((Boolean)object);
        int n = (int)Std.parseFloat(Runtime.toString(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.RESULT_POST_DELAY_MS_KEY)));
        Object object2 = this.sdkParameters.minPostFrequencyMs;
        if (bl) {
            if (Runtime.eq(object2, null)) {
                return -1;
            }
            return Runtime.toInt(object2);
        }
        if (!Runtime.eq(object2, null) && n < Runtime.toInt(object2)) {
            return Runtime.toInt(object2);
        }
        return n;
    }

    public void _submitResultsIfNecessary() {
        if (this._resetSubmitTimeIfNeeded(null)) {
            this._flushTrackingInternal();
        }
    }

    public void reloadFromDisk() {
        ABTMetadata aBTMetadata = (ABTMetadata)ABTPersistence.loadObject(ABTPersistence.kMetadataKey, null);
        if (aBTMetadata != null) {
            ABTLogger.v("Existing metadata loaded from storage, will update if necessary.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "reloadFromDisk"}, new String[]{"lineNumber"}, new double[]{261.0}));
            this.onMetadataLoaded(aBTMetadata);
        } else {
            ABTLogger.v("No existing metadata found in storage.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "reloadFromDisk"}, new String[]{"lineNumber"}, new double[]{264.0}));
        }
    }

    public ABTFilterEnvironment getRequestlessEnvironment(ABTMetadata aBTMetadata) {
        String string = "anon";
        Object var3_3 = null;
        Object var4_4 = null;
        ABTFilterEnvParams aBTFilterEnvParams = new ABTFilterEnvParams(Runtime.toString(var3_3), Runtime.toString(string), var4_4, Runtime.toString(aBTMetadata.getAppKey()), ABTApplicationProperties.sharedInstance(), ABTInternalProperties.sharedInstance());
        ABTFilterEnvironment aBTFilterEnvironment = aBTMetadata.makeEnvironment(aBTFilterEnvParams, this.sdkParameters);
        return aBTFilterEnvironment;
    }

    public Array<String> getUrlsForMetadata(ABTMetadata aBTMetadata) {
        ABTFilterEnvironment aBTFilterEnvironment = this.getRequestlessEnvironment(aBTMetadata);
        Array<String> array = aBTMetadata.extractNeededSecondaryUrls(aBTFilterEnvironment);
        return array;
    }

    public void onMetadataLoaded(ABTMetadata aBTMetadata) {
        this.sdkParameters = aBTMetadata.extractSdkParameters(this.getRequestlessEnvironment(aBTMetadata));
        Array<String> array = this.getUrlsForMetadata(aBTMetadata);
        ABTDataStore aBTDataStore = this;
        this.newMdFetcher.fetch(array, aBTMetadata.getSecondaryValues(), new ABTDataStore_onMetadataLoaded_310__Fun(array, aBTMetadata, aBTDataStore));
    }

    public void onMetadataReceived(ABTMetadata aBTMetadata) {
        if (this.newMdFetcher.fetching()) {
            ABTLogger.e("onMetadataReceived called while fetch already in progress", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "onMetadataReceived"}, new String[]{"lineNumber"}, new double[]{335.0}));
            return;
        }
        this.sdkParameters = aBTMetadata.extractSdkParameters(this.getRequestlessEnvironment(aBTMetadata));
        Array<String> array = this.getUrlsForMetadata(aBTMetadata);
        StringMap<Array<String>> stringMap = null;
        ABTMetadata aBTMetadata2 = this.getMetaData(aBTMetadata.getAppKey());
        if (aBTMetadata2 != null) {
            stringMap = aBTMetadata2.getSecondaryValues();
        }
        ABTDataStore aBTDataStore = this;
        this.newMdFetcher.fetch(array, stringMap, new ABTDataStore_onMetadataReceived_348__Fun(array, aBTMetadata, aBTDataStore));
    }

    public void overrideMetadata(ABTMetadata aBTMetadata, boolean bl, boolean bl2) {
        String string;
        ABTMetadata aBTMetadata2 = null;
        boolean bl3 = true;
        boolean bl4 = false;
        ABTDataLock.METADATA_LOCK.acquire();
        try {
            bl3 = Runtime.valEq(aBTMetadata.getAppKey(), ABTDataStore.getAppKey());
            string = aBTMetadata.getAppKey();
            aBTMetadata2 = (ABTMetadata)this.metaDataCache.get(string);
            if (bl3) {
                if (aBTMetadata2 == null || aBTMetadata2.getSequenceNumber() < aBTMetadata.getSequenceNumber()) {
                    bl4 = true;
                }
                if (bl4 || bl2) {
                    this.metaDataCache.set(string, aBTMetadata);
                    this.sdkParameters = aBTMetadata.extractSdkParameters(this.getRequestlessEnvironment(aBTMetadata));
                    if (bl) {
                        ABTPersistence.saveObject(ABTPersistence.kDisabledVersions, aBTMetadata.getDisabledVersions(), null, null);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            ABTDataLock.METADATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        ABTDataLock.METADATA_LOCK.release();
        aBTMetadata.copyPersistentValues(aBTMetadata2);
        if (bl4 && bl || bl2) {
            this.writeToDiskIfNeeded();
            this.dispatchEnrollmentChangeCallbacks(aBTMetadata2, aBTMetadata);
        }
        if (bl4) {
            ABTEventManager.dispatchOnMetadataUpdated();
            ABTLogger.i("Updated metadata for app key \"" + aBTMetadata.getAppKey() + "\".", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "overrideMetadata"}, new String[]{"lineNumber"}, new double[]{456.0}));
            string = null;
            ABTLogger.v("New metadata:\n" + JsonPrinter.print(aBTMetadata.getMetaData(), (Function)((Object)string), "  "), new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "overrideMetadata"}, new String[]{"lineNumber"}, new double[]{458.0}));
            if ((aBTMetadata2 == null || Runtime.eq(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.REFRESH_META_DATA_ON_SETUP), true)) && ApptimizeInternal._trySetReady()) {
                ABTEventManager.dispatchOnApptimizeInitialized();
                ABTLogger.i("Apptimize initialized after metadata download.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "overrideMetadata"}, new String[]{"lineNumber"}, new double[]{465.0}));
            }
        } else {
            ABTLogger.i("Existing metadata is up-to-date.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "overrideMetadata"}, new String[]{"lineNumber"}, new double[]{469.0}));
            if (Runtime.eq(ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.REFRESH_META_DATA_ON_SETUP), true) && ApptimizeInternal._trySetReady()) {
                ABTEventManager.dispatchOnApptimizeInitialized();
                ABTLogger.i("Apptimize initialized after metadata unchanged.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "overrideMetadata"}, new String[]{"lineNumber"}, new double[]{476.0}));
            }
        }
    }

    public ABTMetadata getMetaData(String string) {
        if (this.metaDataCache == null) {
            return null;
        }
        ABTMetadata aBTMetadata = null;
        ABTDataLock.METADATA_LOCK.acquire();
        try {
            aBTMetadata = (ABTMetadata)this.metaDataCache.get(string);
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            ABTDataLock.METADATA_LOCK.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        ABTDataLock.METADATA_LOCK.release();
        if (aBTMetadata != null && !Runtime.valEq(aBTMetadata.getAppKey(), string)) {
            ABTLogger.e("Metadata appkey does not match requested key", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "getMetaData"}, new String[]{"lineNumber"}, new double[]{494.0}));
            return null;
        }
        return aBTMetadata;
    }

    public void dispatchEnrollmentChangeCallbacks(ABTMetadata aBTMetadata, ABTMetadata aBTMetadata2) {
    }

    public ABTFilterEnvironment makeEnvironment(ABTFilterEnvParams aBTFilterEnvParams) {
        ABTMetadata aBTMetadata = this.getMetaData(aBTFilterEnvParams.appkey);
        if (aBTMetadata == null) {
            return null;
        }
        return aBTMetadata.makeEnvironment(aBTFilterEnvParams, this.sdkParameters);
    }

    public void writeToDiskIfNeeded() {
        ABTMetadata aBTMetadata = this.getMetaData(ABTDataStore.getAppKey());
        if (aBTMetadata != null) {
            ABTPersistence.saveObject(ABTPersistence.kMetadataKey, aBTMetadata, null, true);
        }
    }

    public void _saveResultLogs() {
        ABTPersistence.saveObject(ABTPersistence.kResultLogsKey, this.resultLogs, null, true);
    }

    public void addResultLogEntry(ABTFilterEnvironment aBTFilterEnvironment, ABTResultEntry aBTResultEntry) {
        String string = aBTFilterEnvironment.getUniqueUserID();
        resultsLock.acquire();
        try {
            ABTResultLog aBTResultLog = this.resultLogs.getValue(string);
            if (aBTResultLog == null) {
                aBTResultLog = new ABTResultLog(aBTFilterEnvironment);
                this.resultLogs.insert(string, aBTResultLog, new Closure(this, "_submitResultLog"), this.resultDispatchQueue);
            }
            aBTResultLog.logEntry(aBTResultEntry);
            if (Runtime.compare(aBTResultLog.entryCount(), ABTConfigProperties.sharedInstance().valueForProperty(ABTConfigProperties.MAXIMUM_RESULT_ENTRIES_KEY)) > 0) {
                this.resultLogs.remove(string, new Closure(this, "_submitResultLog"), this.resultDispatchQueue);
            }
            this._saveResultLogs();
            this._submitResultsIfNecessary();
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            resultsLock.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        resultsLock.release();
    }

    public void _submitResultLog(ABTResultLog aBTResultLog) {
        if (ABTDataStore.shouldDisable()) {
            return;
        }
        ABTApiClient.sharedInstance().postResultsForKey(aBTResultLog.getAppKey(), aBTResultLog);
        this._saveResultLogs();
    }

    public void flushTracking() {
        if (this._resetSubmitTimeIfNeeded(true)) {
            this._flushTrackingInternal();
        }
    }

    public void _flushTrackingInternal() {
        ABTLogger.v("Posting results...", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "_flushTrackingInternal"}, new String[]{"lineNumber"}, new double[]{752.0}));
        resultsLock.acquire();
        try {
            this.resultLogs.clear(new Closure(this, "_submitResultLog"), this.resultDispatchQueue);
            this._saveResultLogs();
        }
        catch (Throwable throwable) {
            NativeStackTrace.exception.set(throwable);
            Object object = Exception.caught(throwable).unwrap();
            resultsLock.release();
            throw (RuntimeException)Exception.thrown(object);
        }
        resultsLock.release();
    }

    public void incrementVariantRunCount(ABTFilterEnvParams aBTFilterEnvParams, ABTVariant aBTVariant) {
        if (Type.getClass(aBTVariant) == ABTHotfixVariant.class) {
            return;
        }
        String string = "v" + aBTVariant.getVariantID() + "_" + aBTVariant.getCycle();
        String string2 = "e" + aBTVariant.getExperimentID() + "_" + aBTVariant.getCycle();
        int n = aBTVariant.getPhase();
        boolean bl = false;
        ABTFilterEnvironment aBTFilterEnvironment = this.makeEnvironment(aBTFilterEnvParams);
        ABTResultEntryVariantShown aBTResultEntryVariantShown = new ABTResultEntryVariantShown(aBTFilterEnvironment, aBTVariant.getVariantID(), aBTVariant.getCycle(), n);
        ABTLogger.v("Incrementing variant run count for variant ID \"" + aBTVariant.getVariantID() + "\".", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "incrementVariantRunCount"}, new String[]{"lineNumber"}, new double[]{787.0}));
        VariantInfo variantInfo = VariantInfo.initWithVariant(aBTVariant, aBTFilterEnvironment.userID, aBTFilterEnvironment.anonID);
        ABTEventManager.dispatchOnParticipatedInExperiment(variantInfo, bl);
        this.addResultLogEntry(aBTFilterEnvironment, aBTResultEntryVariantShown);
    }

    public void generateEvent(String string, String string2, StringMap<Object> stringMap, ABTFilterEnvParams aBTFilterEnvParams) {
        if (!Apptimize._isInitialized() || ABTDataStore.sharedInstance().getMetaData(aBTFilterEnvParams.appkey) == null) {
            ABTLogger.w("Event \"" + string + "\" will not be tracked until Apptimize.setup() is called and MetaData available.", new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "generateEvent"}, new String[]{"lineNumber"}, new double[]{798.0}));
            return;
        }
        ABTFilterEnvironment aBTFilterEnvironment = this.makeEnvironment(aBTFilterEnvParams);
        ABTResultEntryEvent aBTResultEntryEvent = new ABTResultEntryEvent(aBTFilterEnvironment, Runtime.toString(string), Runtime.toString(string2), stringMap);
        String string3 = "Event \"" + string + "\"";
        if (stringMap != null) {
            string3 = string3 + " with value " + Std.string(stringMap.get(ApptimizeInternal.kABTValueEventKey));
        }
        string3 = string3 + " tracked.";
        ABTLogger.v(string3, new DynamicObject(new String[]{"className", "fileName", "methodName"}, new Object[]{"com.apptimize.ABTDataStore", "src/apptimize/ABTDataStore.hx", "generateEvent"}, new String[]{"lineNumber"}, new double[]{812.0}));
        this.addResultLogEntry(aBTFilterEnvironment, aBTResultEntryEvent);
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case -201270844: {
                    if (!string.equals("sdkParameters")) break;
                    bl2 = false;
                    this.sdkParameters = (ABTSdkParameters)object;
                    return object;
                }
                case -572085396: {
                    if (!string.equals("resultLogs")) break;
                    bl2 = false;
                    this.resultLogs = (ABTLRUCache)object;
                    return object;
                }
                case 1763893146: {
                    if (!string.equals("resultDispatchQueue")) break;
                    bl2 = false;
                    this.resultDispatchQueue = (ABTDispatch)object;
                    return object;
                }
                case -24442509: {
                    if (!string.equals("metaDataCache")) break;
                    bl2 = false;
                    this.metaDataCache = (StringMap)object;
                    return object;
                }
                case 1079750772: {
                    if (!string.equals("propChangeFetcher")) break;
                    bl2 = false;
                    this.propChangeFetcher = (ABTSecondaryValuesClient)object;
                    return object;
                }
                case -249759344: {
                    if (!string.equals("newMdFetcher")) break;
                    bl2 = false;
                    this.newMdFetcher = (ABTSecondaryValuesClient)object;
                    return object;
                }
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 1720159781: {
                    if (!string.equals("generateEvent")) break;
                    bl4 = false;
                    return new Closure(this, "generateEvent");
                }
                case -572085396: {
                    if (!string.equals("resultLogs")) break;
                    bl4 = false;
                    return this.resultLogs;
                }
                case 670147962: {
                    if (!string.equals("incrementVariantRunCount")) break;
                    bl4 = false;
                    return new Closure(this, "incrementVariantRunCount");
                }
                case -24442509: {
                    if (!string.equals("metaDataCache")) break;
                    bl4 = false;
                    return this.metaDataCache;
                }
                case -1584932167: {
                    if (!string.equals("_flushTrackingInternal")) break;
                    bl4 = false;
                    return new Closure(this, "_flushTrackingInternal");
                }
                case -249759344: {
                    if (!string.equals("newMdFetcher")) break;
                    bl4 = false;
                    return this.newMdFetcher;
                }
                case -1676969509: {
                    if (!string.equals("flushTracking")) break;
                    bl4 = false;
                    return new Closure(this, "flushTracking");
                }
                case 1079750772: {
                    if (!string.equals("propChangeFetcher")) break;
                    bl4 = false;
                    return this.propChangeFetcher;
                }
                case -1343397264: {
                    if (!string.equals("_submitResultLog")) break;
                    bl4 = false;
                    return new Closure(this, "_submitResultLog");
                }
                case 1763893146: {
                    if (!string.equals("resultDispatchQueue")) break;
                    bl4 = false;
                    return this.resultDispatchQueue;
                }
                case 1938470348: {
                    if (!string.equals("addResultLogEntry")) break;
                    bl4 = false;
                    return new Closure(this, "addResultLogEntry");
                }
                case -201270844: {
                    if (!string.equals("sdkParameters")) break;
                    bl4 = false;
                    return this.sdkParameters;
                }
                case -846676248: {
                    if (!string.equals("_saveResultLogs")) break;
                    bl4 = false;
                    return new Closure(this, "_saveResultLogs");
                }
                case 871091088: {
                    if (!string.equals("initialize")) break;
                    bl4 = false;
                    return new Closure(this, "initialize");
                }
                case 2054500297: {
                    if (!string.equals("writeToDiskIfNeeded")) break;
                    bl4 = false;
                    return new Closure(this, "writeToDiskIfNeeded");
                }
                case -1870514199: {
                    if (!string.equals("hasMetadata")) break;
                    bl4 = false;
                    return new Closure(this, "hasMetadata");
                }
                case -275090619: {
                    if (!string.equals("makeEnvironment")) break;
                    bl4 = false;
                    return new Closure(this, "makeEnvironment");
                }
                case 1444031255: {
                    if (!string.equals("_getCurrentEtag")) break;
                    bl4 = false;
                    return new Closure(this, "_getCurrentEtag");
                }
                case 709214208: {
                    if (!string.equals("dispatchEnrollmentChangeCallbacks")) break;
                    bl4 = false;
                    return new Closure(this, "dispatchEnrollmentChangeCallbacks");
                }
                case 832819797: {
                    if (!string.equals("loadMetaData")) break;
                    bl4 = false;
                    return new Closure(this, "loadMetaData");
                }
                case 1626942661: {
                    if (!string.equals("getMetaData")) break;
                    bl4 = false;
                    return new Closure(this, "getMetaData");
                }
                case 585124295: {
                    if (!string.equals("_resetSubmitTimeIfNeeded")) break;
                    bl4 = false;
                    return new Closure(this, "_resetSubmitTimeIfNeeded");
                }
                case -539201765: {
                    if (!string.equals("overrideMetadata")) break;
                    bl4 = false;
                    return new Closure(this, "overrideMetadata");
                }
                case -787676557: {
                    if (!string.equals("_getMinTimeBetweenPosts")) break;
                    bl4 = false;
                    return new Closure(this, "_getMinTimeBetweenPosts");
                }
                case 129752623: {
                    if (!string.equals("onMetadataReceived")) break;
                    bl4 = false;
                    return new Closure(this, "onMetadataReceived");
                }
                case 1452526195: {
                    if (!string.equals("_submitResultsIfNecessary")) break;
                    bl4 = false;
                    return new Closure(this, "_submitResultsIfNecessary");
                }
                case -1695424557: {
                    if (!string.equals("onMetadataLoaded")) break;
                    bl4 = false;
                    return new Closure(this, "onMetadataLoaded");
                }
                case -1329401568: {
                    if (!string.equals("reloadFromDisk")) break;
                    bl4 = false;
                    return new Closure(this, "reloadFromDisk");
                }
                case 811822430: {
                    if (!string.equals("getUrlsForMetadata")) break;
                    bl4 = false;
                    return new Closure(this, "getUrlsForMetadata");
                }
                case -2080529599: {
                    if (!string.equals("getRequestlessEnvironment")) break;
                    bl4 = false;
                    return new Closure(this, "getRequestlessEnvironment");
                }
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Object[] objectArray) {
        boolean bl = true;
        if (string != null) {
            switch (string.hashCode()) {
                case 1720159781: {
                    if (!string.equals("generateEvent")) break;
                    bl = false;
                    this.generateEvent(Runtime.toString(objectArray[0]), Runtime.toString(objectArray[1]), (StringMap)objectArray[2], (ABTFilterEnvParams)objectArray[3]);
                    break;
                }
                case 871091088: {
                    if (!string.equals("initialize")) break;
                    bl = false;
                    this.initialize();
                    break;
                }
                case 670147962: {
                    if (!string.equals("incrementVariantRunCount")) break;
                    bl = false;
                    this.incrementVariantRunCount((ABTFilterEnvParams)objectArray[0], (ABTVariant)objectArray[1]);
                    break;
                }
                case -1870514199: {
                    if (!string.equals("hasMetadata")) break;
                    bl = false;
                    return this.hasMetadata(Runtime.toString(objectArray[0]));
                }
                case -1584932167: {
                    if (!string.equals("_flushTrackingInternal")) break;
                    bl = false;
                    this._flushTrackingInternal();
                    break;
                }
                case 1444031255: {
                    if (!string.equals("_getCurrentEtag")) break;
                    bl = false;
                    return this._getCurrentEtag(Runtime.toString(objectArray[0]));
                }
                case -1676969509: {
                    if (!string.equals("flushTracking")) break;
                    bl = false;
                    this.flushTracking();
                    break;
                }
                case 832819797: {
                    if (!string.equals("loadMetaData")) break;
                    bl = false;
                    this.loadMetaData(Runtime.toString(objectArray[0]));
                    break;
                }
                case -1343397264: {
                    if (!string.equals("_submitResultLog")) break;
                    bl = false;
                    this._submitResultLog((ABTResultLog)objectArray[0]);
                    break;
                }
                case 585124295: {
                    if (!string.equals("_resetSubmitTimeIfNeeded")) break;
                    bl = false;
                    return this._resetSubmitTimeIfNeeded(objectArray.length > 0 ? objectArray[0] : null);
                }
                case 1938470348: {
                    if (!string.equals("addResultLogEntry")) break;
                    bl = false;
                    this.addResultLogEntry((ABTFilterEnvironment)objectArray[0], (ABTResultEntry)objectArray[1]);
                    break;
                }
                case -787676557: {
                    if (!string.equals("_getMinTimeBetweenPosts")) break;
                    bl = false;
                    return this._getMinTimeBetweenPosts(objectArray.length > 0 ? objectArray[0] : null);
                }
                case -846676248: {
                    if (!string.equals("_saveResultLogs")) break;
                    bl = false;
                    this._saveResultLogs();
                    break;
                }
                case 1452526195: {
                    if (!string.equals("_submitResultsIfNecessary")) break;
                    bl = false;
                    this._submitResultsIfNecessary();
                    break;
                }
                case 2054500297: {
                    if (!string.equals("writeToDiskIfNeeded")) break;
                    bl = false;
                    this.writeToDiskIfNeeded();
                    break;
                }
                case -1329401568: {
                    if (!string.equals("reloadFromDisk")) break;
                    bl = false;
                    this.reloadFromDisk();
                    break;
                }
                case -275090619: {
                    if (!string.equals("makeEnvironment")) break;
                    bl = false;
                    return this.makeEnvironment((ABTFilterEnvParams)objectArray[0]);
                }
                case -2080529599: {
                    if (!string.equals("getRequestlessEnvironment")) break;
                    bl = false;
                    return this.getRequestlessEnvironment((ABTMetadata)objectArray[0]);
                }
                case 709214208: {
                    if (!string.equals("dispatchEnrollmentChangeCallbacks")) break;
                    bl = false;
                    this.dispatchEnrollmentChangeCallbacks((ABTMetadata)objectArray[0], (ABTMetadata)objectArray[1]);
                    break;
                }
                case 811822430: {
                    if (!string.equals("getUrlsForMetadata")) break;
                    bl = false;
                    return this.getUrlsForMetadata((ABTMetadata)objectArray[0]);
                }
                case 1626942661: {
                    if (!string.equals("getMetaData")) break;
                    bl = false;
                    return this.getMetaData(Runtime.toString(objectArray[0]));
                }
                case -1695424557: {
                    if (!string.equals("onMetadataLoaded")) break;
                    bl = false;
                    this.onMetadataLoaded((ABTMetadata)objectArray[0]);
                    break;
                }
                case -539201765: {
                    if (!string.equals("overrideMetadata")) break;
                    bl = false;
                    this.overrideMetadata((ABTMetadata)objectArray[0], Runtime.toBool((Boolean)objectArray[1]), Runtime.toBool((Boolean)objectArray[2]));
                    break;
                }
                case 129752623: {
                    if (!string.equals("onMetadataReceived")) break;
                    bl = false;
                    this.onMetadataReceived((ABTMetadata)objectArray[0]);
                }
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, objectArray);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("sdkParameters");
        array.push("resultDispatchQueue");
        array.push("propChangeFetcher");
        array.push("newMdFetcher");
        array.push("metaDataCache");
        array.push("resultLogs");
        super.__hx_getFields(array);
    }

    static {
        resultsLock = ABTDataLock.getNewLock("datastore_results_lock");
    }
}

