function init()
  m.top.functionName = "eventLoop"
  m.timeout = -1
  m.messagePort = createObject("roMessagePort")
  m.requests = CreateObject("roArray",0,true)

  m.top.observeField("requestAdded", m.messagePort)

  m.top.control = "RUN"
end function

function isFeatureFlagEnabled(params as Object)
  getRequest(params, "isFeatureFlagEnabled", "feature-flags", {userId:1, name:1, id:1, method:1, pilotId:0, customAttributes:0})
end function

function getCodeBlock(params as Object)
  getRequest(params, "getCodeBlock", "code-blocks", {userId:1, name:1, id:1, method:1, pilotId:0, customAttributes: 0})
end function

function getVariantInfo(params as Object)
  getRequest(params, "getVariantInfo", "variant-info", {userId:1, id:1, method:1, pilotId:0, customAttributes: 0})
end function

function getRequest(params as Object, methodName as String, path as String, supportedParams as Object)
  options = getApptimizeOptions()
  if (options = invalid) then
    ApptimizeLog("Please call ApptimizeSetup before calling "+methodName, Apptimize().LOG_LEVEL.ERROR)
    return invalid
  end if

  setUserParams(options, params)

  if (validateRequiredParams(methodName, supportedParams, params) = false) then
    return invalid
  end if

  rq = {
    host : options.host,
    userId : params.userId,
    pilotId: params.pilotId,
    apiToken : options.apiToken,
    requestMethod : "GET",
    method : params.method,
    id : params.id,
    queryAttributes : {}
  }

  if params.customAttributes <> invalid then
    rq.queryAttributes.customAttributes = params.customAttributes
  end if

  rq.uri = "/users/"+params.userId+"/"+path
  if params.name <> invalid then rq.uri += "/"+params.name
  
  pushRequest(rq)
end function

function getDynamicVariable(params as Object)
  options = getApptimizeOptions()
  if (options = invalid) then
    ApptimizeLog("Please call ApptimizeSetup before getting dynamic variables", Apptimize().LOG_LEVEL.ERROR)
    return invalid
  end if

  setUserParams(options, params)

  supportedParams = {id: 1, userId:1, pilotId:0, defaultValue:1, name:1, method: 1, variableType:1, customAttributes: 0}

  if (validateRequiredParams("dynamic variables", supportedParams, params) = false) then
    return invalid
  end if

  rq = {
    host : options.host,
    userId : params.userId,
    pilotId: params.pilotId,
    apiToken : options.apiToken,
    requestMethod : "GET",
    method : params.method,
    id : params.id,
    queryAttributes : {
                        defaultValue : params.defaultValue
                      }
  }

  if params.customAttributes <> invalid then
    rq.queryAttributes.customAttributes = params.customAttributes
  end if

  rq.uri = "/users/"+params.userId+"/dynamic-variables/"+params.variableType+"/"+params.name
   
  pushRequest(rq)

end function  

function track(params as Object)
  options = getApptimizeOptions()
  if (options = invalid) then
    ApptimizeLog("Please call ApptimizeSetup before tracking events", Apptimize().LOG_LEVEL.ERROR)
    return invalid
  end if

  setUserParams(options, params)

  supportedParams = {id:1, userId:1, pilotId:0, value:0, name:1, method:1, customAttributes: 0}

  if (validateRequiredParams("track", supportedParams, params) = false) then
    return invalid
  end if

  rq = {
    host : options.host,
    userId : params.userId,
    pilotId : params.pilotId,
    apiToken : options.apiToken,
    method : params.method,
    id : params.id,
    queryAttributes : {}
  }

  if params.value <> invalid then
    rq.queryAttributes.value = params.value
  end if

  if params.customAttributes <> invalid then
    rq.queryAttributes.customAttributes = params.customAttributes
  end if

  rq.uri = "/users/"+params.userId+"/events/"+params.name
  rq.requestMethod = "POST"

  pushRequest(rq)
end function  

function getUri(request as Object)
  fullUri = request.host + request.uri

  payload = getPayload(request)

  if request.requestMethod = "GET" and payload <> "" then fullUri += "?"+payload

  return fullUri
end function

function getPayload(request as Object)
  output = ""
  if request.queryAttributes <> invalid then
    for each attr in request.queryAttributes.keys()
      attributeAsString = request.queryAttributes[attr]

      if GetInterface(attributeAsString, "ifString") = invalid then
        attributeAsString = FormatJson(attributeAsString)
      end if

      attrKeyAsString = attr

      if attr = "defaultvalue" then attrKeyAsString = "defaultValue"
      if attr = "customattributes" then attrKeyAsString = "customAttributes"

      if len(output) > 0 then output += "&"

      output += attrKeyAsString+"="+attributeAsString.EncodeUriComponent()

    end for
  end if
  return output
end function

function createUrlTransfer(port as Object) as Object
  urlTransfer = CreateObject("roUrlTransfer")
  urlTransfer.SetCertificatesFile("common:/certs/ca-bundle.crt")
  urlTransfer.AddHeader("Content-Type", "application/x-www-form-urlencoded")
  urlTransfer.AddHeader("Accept", "*/*")
  urlTransfer.AddHeader("Expect", "")
  urlTransfer.AddHeader("Connection", "keep-alive")
  urlTransfer.AddHeader("Accept-Encoding", "gzip, deflate, br")

  options = getApptimizeOptions()
  urlTransfer.AddHeader("ApptimizeApiToken", options.apiToken)

  di = CreateObject("roDeviceInfo")
  urlTransfer.AddHeader("ApptimizeApplicationProperties", FormatJson({apptimize_platform: "Roku"}))
  urlTransfer.AddHeader("ApptimizePlatform", "Roku")
  urlTransfer.AddHeader("ApptimizeOperatingSystemVersion", di.GetVersion())

  if options.appName <> invalid then
    urlTransfer.AddHeader("ApptimizeApplicationName", options.appName)
  end if

  if options.appVersion <> invalid then
    urlTransfer.AddHeader("ApptimizeApplicationVersion", options.appVersion)
  end if

  urlTransfer.RetainBodyOnError(true)
  urlTransfer.EnableEncodings(true)
  urlTransfer.setPort(port)

  return urlTransfer
end function

sub processRequest(request as Object)
  m.currentRequest = request
  url = getUri(request)

  ApptimizeLog("Making REST Request: "+url, Apptimize().LOG_LEVEL.VERBOSE)
  
  m.urlTransfer.SetUrl(url)


  if request.pilotId <> invalid then
    m.urlTransfer.AddHeader("ApptimizePilotTargetingId", request.pilotId)
  else
    m.urlTransfer.AddHeader("ApptimizePilotTargetingId",  "")
  end if


  if request.requestMethod = "POST" then
    body = getPayload(request)
    m.urlTransfer.SetRequest("POST")
    m.urlTransfer.AsyncPostFromString(body)
  else
    m.urlTransfer.SetRequest("GET")
    m.urlTransfer.AsyncGetToString()
  end if
end sub

function pushRequest(request as Object)
  m.top.requestAdded = request
end function

function getNextRequest()
  if m.requests.Count() > 0 then
    return m.requests.shift()
  end if
  return invalid
end function

function processNextRequest()
  if m.currentRequest <> invalid then
    return invalid
  end if

  r = getNextRequest()
  if r <> Invalid then
    processRequest(r)
  end if  
end function

sub eventLoop()
  m.urlTransfer = createUrlTransfer(m.messagePort)

  while true
    event = wait(0, m.messagePort)
    if event <> Invalid then
      if type(event) = "roSGNodeEvent" then
        if event.getField() = "requestAdded" then
          m.requests.push(event.getData())
          processNextRequest()
        else
          
        end if       
      else if type(event) = "roUrlEvent" then
        response = event.getString()
        ApptimizeLog("Got Response: "+response, Apptimize().LOG_LEVEL.VERBOSE)
        
        if response <> invalid and len(response) > 0 then response = ParseJSON(response)

        success = true

        if event.getResponseCode() < 0 or event.getResponseCode() >= 400 then success = false

        rp = {
          id : m.currentRequest.id,
          success: success,
          method: m.currentRequest.method,
          response: response
        }

        if (m.currentRequest.method = "getDynamicVariable") then
          rp.name = m.currentRequest.name
        end if

        m.top.content = rp
        m.currentRequest = invalid

        processNextRequest()
      end if  

    end if
  end while

end sub


