function init()
  m.global.addFields({apptimize : m.top})
  m.currentThread = 0
  m.idCount = 0

  m.top.addField("initSet", "bool", false)
  m.top.observeField("initSet", "initialize")
end function

function initialize()
  logLevel = m.top.logLevel
  region = m.top.region

  if logLevel = invalid or Apptimize().LOG_LEVEL[logLevel] = invalid then
    print "Apptimize: Unsupported logLevel. Defaulting to 'ERROR'"
    m.top.logLevel = "ERROR"
    m.global.apptimize = m.top
  end if
  
  if region = invalid or (region <> "default" and region <> "eucs") then
    ApptimizeLog("Apptimize: Unsupported region. Defaulting to 'default'", Apptimize().LOG_LEVEL.WARN)
    m.top.region = "default"
    m.global.apptimize = m.top
  end if

  if region = "eucs" then
    m.top.host = "https://api.apptimize.eu/v1"
    m.global.apptimize = m.top
  end if 
  
  m.threadCount = m.top.threads

  if m.threadCount < 1 then 
    ApptimizeLog("Thread Count must be greater than 0.  Defaulting to 1", Apptimize().LOG_LEVEL.WARN)
    m.threadCount = 1
  end if

  m.taskList = CreateObject("roArray", m.threadCount, true)
  
  for i = 0 To m.threadCount
    task = createObject("RoSGNode", "ApptimizeTask")
    task.observeField("content", "setcontent")
    m.taskList[i] = task
  end for
end function

function getString(params as Object)
  return getTaskDynamicVariable(params, "getString", "string")
end function

function getInt(params as Object)
  return getTaskDynamicVariable(params, "getInt", "int")
end function

function getBool(params as Object)
  return getTaskDynamicVariable(params, "getBool", "bool")
end function

function getDouble(params as Object)
  return getTaskDynamicVariable(params, "getDouble", "double")
end function

function getDoubleArray(params as Object)
  return getTaskDynamicVariable(params, "getDoubleArray", "double-array")
end function

function getStringArray(params as Object)
  return getTaskDynamicVariable(params, "getStringArray", "string-array")
end function

function getIntArray(params as Object)
  return getTaskDynamicVariable(params, "getIntArray", "int-array")
end function

function getBoolArray(params as Object)
  return getTaskDynamicVariable(params, "getBoolArray", "bool-array")
end function

function getDoubleDictionary(params as Object)
  return getTaskDynamicVariable(params, "getDoubleDictionary", "double-dictionary")
end function

function getStringDictionary(params as Object)
  return getTaskDynamicVariable(params, "getStringDictionary", "string-dictionary")
end function

function getIntDictionary(params as Object)
  return getTaskDynamicVariable(params, "getIntDictionary", "int-dictionary")
end function

function getBoolDictionary(params as Object)
  return getTaskDynamicVariable(params, "getBoolDictionary", "bool-dictionary")
end function

function getVariantInfo(params as Object)
  params.method = "getVariantInfo"
  params.id = getNextId(params.method)

  callOnThread("getVariantInfo", params)
  return params.id
end function

function isFeatureFlagEnabled(params as Object)
  params.id = getNextId("isFeatureFlagEnabled")
  params.method = "isFeatureFlagEnabled"
  callOnThread("isFeatureFlagEnabled", params)
  return params.id
end function

function track(params as Object)
  params.method = "track"
  params.id = getNextId("track")
  callOnThread("track", params)
  return params.id
end function

function getTaskDynamicVariable(params as Object, method as String, variableType as String)
  params.method = method
  params.variableType = variableType
  params.id = getNextId(method)

  callOnThread("getDynamicVariable", params)
  return params.id
end function

function getCodeBlock(params as Object)
  params.method = "getCodeBlock"
  params.id = getNextId("getCodeBlock")
  callOnThread("getCodeBlock", params)
  return params.id
end function

function callOnThread(functionName as String, params as Object)
  m.top.initSet = true
  m.currentThread++
  if m.currentThread >= m.threadCount then m.currentThread = 0

  m.taskList[m.currentThread].callFunc(functionName, params)
end function

function getNextId(method as String)
  m.idCount++
  return method+"_"+m.idCount.ToStr()
end function

function setcontent(message as Object)
  m.top.content = message.getData()
end function  

