function Apptimize()
  DEFAULTS = {
      logLevel : "VERBOSE",
      host : "https://api.apptimize.com/v1" 
      region : "default"
  }

  LOG_LEVEL = {
    VERBOSE : 0,
    DEBUG : 1,
    INFO : 2,
    WARN : 3,
    ERROR : 4,
    NONE : 5
  }

  return {
    DEFAULTS : DEFAULTS,
    LOG_LEVEL : LOG_LEVEL
  }
end function

function ApptimizeLog(message as String, level as Integer)
  options = getApptimizeOptions()
  showMessage = true

  if options <> invalid then
    logLevel = options.logLevel.ToStr()

     if (Apptimize().LOG_LEVEL[logLevel] > level) then
      showMessage = false  
    end if
  end if
  
  if showMessage then
    print "Apptimize: "+message
  endif
end function

function getApptimizeOptions()
    return m.global.apptimize
end function

function setUserParams(options as Object, params as Object)
  if (options.userId <> invalid and params.userId = invalid) then
    params.userId = options.userId
  end if

  if (options.pilotId <> invalid and params.pilotId = invalid) then
    params.pilotId = options.pilotId
  end if

  if (options.customAttributes <> invalid and params.customAttributes = invalid) then
    params.customAttributes = options.customAttributes
  end if
end function

function validateRequiredParams(functionName as String, supportedParams as object, params as object) as Boolean
  keys = supportedParams.keys()
  for each kv in keys
    if (supportedParams[kv] = 1 and params.DoesExist(kv) = false) then
      ApptimizeLog("Missing required parameter for "+functionName+": "+kv, Apptimize().LOG_LEVEL.ERROR)
      return false
    end if
  end for

  keys = params.keys()
  for each kv in keys
    if supportedParams.DoesExist(kv) = false then
      ApptimizeLog("Unsupported parameter '"+kv+"' for "+functionName+"", Apptimize().LOG_LEVEL.ERROR)
      return false
    end if
  end for

  return true
end function